<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div>
                                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#agregarMovil">
									<i class="mdi mdi-plus-circle"></i> Agregar Móvil
								</button>
								<a href="<?= $baseUrl.'/'.$previo ?>" class="btn px-2 py-0" style="border-radius: 45%; background-color: red;"><i class="mdi mdi-arrow-left-circle" style="font-size: 24px; color: #FFF"></i></a>
                            </div>
                        </div>
						<div class="card-body">
							<table id="example" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<!--<th scope="col" style="width: 10px;">
											<div class="form-check">
												<input class="form-check-input fs-15" type="checkbox" id="checkAll" value="option">
											</div>
										</th>-->
										<th class="text-center align-middle">IMEI</th>
										<th class="text-center align-middle">Marca</th>
										<th class="text-center align-middle">Modelo</th>
										<th class="text-center align-middle">Fecha compra</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listaMoviles as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IMEI'] ?></td>
										<td class="text-center align-middle"><?= $items['Marca'] ?></td>
										<td class="text-center align-middle"><?= $items['ModeloComercial'] ?></td>
										<td class="text-center align-middle"><?= $items['FechaCompra'] ?></td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->

<!-- Modal Añadir Móvil -->
<div class="modal fade" id="agregarMovil" tabindex="-1" role="dialog" aria-labelledby="exampleagregarMovil" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleagregarMovil">Agregar Móvil</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" autocomplete="off" action="<?= $baseUrl ?>/grabar-movil-seguro" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" name="txtIdSeguro" id="txtIdSeguro" value="<?= $idSeguro ?>">
					<div class="row">
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
							<label for="txtMarca" class="form-label">Marca</label>
                            <div class="input-group">
                                <input type="text" class="form-control" aria-label="Marca" id="txtMarca" name="txtMarca">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtModeloComercial" class="form-label">Modelo Comercial</label>
                                <input type="text" class="form-control" id="txtModeloComercial" name="txtModeloComercial">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-6 col-12 mb-3">
							<label for="txtProveedor" class="form-label">Proveedor</label>
                            <select class="form-select" aria-label="Proveedor" id="txtProveedor" name="txtProveedor">
                                <option selected="" value="">Seleccione una opción</option>
                                <option value="ENTEL">ENTEL</option>
                                <option value="LOGÍSTICA">LOGÍSTICA</option>
                            </select>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtIMEI" class="form-label">IMEI</label>
                                <input type="number" class="form-control" id="txtIMEI" name="txtIMEI">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtFechaCompra" class="form-label">Fecha Compra</label>
                                <input type="date" class="form-control" id="txtFechaCompra" value="<?= date("Y-m-d") ?>" name="txtFechaCompra">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtPrecioCompra" class="form-label">Precio Compra</label>
                                <input type="number" class="form-control" id="txtPrecioCompra" name="txtPrecioCompra">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-12 col-12 mb-3">
                            <div>
                                <label for="txtPrecioLista" class="form-label">Precio Lista</label>
                                <input type="number" class="form-control" id="txtPrecioLista" name="txtPrecioLista">
                            </div>
                        </div>
						<div class="col-xxl-12 col-md-6 col-12 mb-3">
							<label for="txtEstado" class="form-label">Estado</label>
                            <select class="form-select" aria-label="Estado" id="txtEstado" name="txtEstado">
								<option value="ACTIVO">ACTIVO</option>
                            </select>
                        </div>
						<div class="col-xxl-12 col-md-6 col-12 mb-3">
							<label for="txtSituacion" class="form-label">Situación</label>
                            <select class="form-select" aria-label="Situación" id="txtSituacion" name="txtSituacion">
                                <option value="NUEVO">NUEVO</option>
                            </select>
                        </div>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>