<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div class="d-flex">
								<?php
								if (in_array("CSVHAR", $permisos)) 
								{
								?>
								<button class="btn btn-success d-flex align-items-center mx-1" data-bs-toggle="modal" data-bs-target="#subirCSVHardware">
									<i class="mdi mdi-file-upload" style="font-size: 18px;"></i> Subir CSV
								</button>
								<?php
								}

								if (in_array("ADDHAR", $permisos)) 
								{
								?>
                                <button class="btn btn-primary datos-hardware d-flex align-items-center mx-1" data-bs-toggle="modal" data-bs-target="#informacionHardware" data-id="0" data-accion="crear" id="crear-hardware">
									<i class="mdi mdi-plus-circle" style="font-size: 18px;"></i> Agregar
								</button>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="tblHardware" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<!--<th scope="col" style="width: 10px;">
											<div class="form-check">
												<input class="form-check-input fs-15" type="checkbox" id="checkAll" value="option">
											</div>
										</th>-->
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Hostname</th>
										<th class="text-center align-middle">Estado</th>
										<th class="text-center align-middle">Marca</th>
										<th class="text-center align-middle">Modelo</th>
										<th class="text-center align-middle">Serie</th>
										<th class="text-center align-middle">Matrícula</th>
										<th class="text-center align-middle">Asignado</th>
										<th class="text-center align-middle">Subárea Reserva</th>
										<th class="text-center align-middle">Detalle</th>
										<th class="text-center align-middle">Fin Garantía</th>
										<th class="text-center align-middle">Precio</th>
										<th class="text-center align-middle">Acciones</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listaHardware as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDHardware'] ?></td>
										<td class="text-center align-middle"><?= $items['Hostname'] ?></td>
										<td class="text-center align-middle">
											<span class="badge <?= $items['Estado'] == 'ACT' ? "bg-success" : ($items['Estado'] == 'BAJ' ? "bg-danger" : "bg-warning") ?> border-0"><?= $items['Estado'] == 'ACT' ? "ACTIVO" : ($items['Estado'] == 'BAJ' ? 'BAJA' : 'AVERIADO') ?></span>
										</td>
										<td class="text-center align-middle"><?= $items['Marca'] ?></td>
										<td class="text-center align-middle"><?= $items['Modelo'] ?></td>
										<td class="text-center align-middle"><?= $items['Serie'] ?></td>
										<td class="text-center align-middle"><?= $items['MatriculaAsignado'] ?></td>
										<td class="text-center align-middle">
											<?php
											if($items['UsuarioAsignado'] != '--')
											{
											?>
											<span class="badge <?= $items['EstadoAsignado'] == 'Activo' ? 'bg-light text-dark' : 'bg-danger color-white' ?> border-0"><?= $items['UsuarioAsignado'] ?></span>
											<?php
											}
											else
											{
											?>
											No asignado
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
										    <span class="badge <?= $items['SubareaReserva']  == 'Libre' ? "bg-light text-dark" : "bg-warning text-dark" ?> border-0"><?= $items['SubareaReserva'] ?></span>
										</td>
										<td class="text-center align-middle"><?= $items['Detalle'] ?></td>
										<td class="text-center align-middle">
										    <?php
										    if($items['FinalGarantia'] == '' || $items['FinalGarantia'] == null || $items['FinalGarantia'] == '0000-00-00')
										    {
										    ?>
										    <span class="badge bg-info border-0">Sin Información</span>
										    <?php
										    }
										    else
										    {
										        echo date("d-m-Y", strtotime($items['FinalGarantia']));
										    } 
										    ?>
										</td>
										<td class="text-center align-middle"><?= ($items['MonedaCompra'] == "USD" ? '$' : ($items['MonedaCompra'] == "EUR" ? "€" : "S/")).' '.$items['PrecioCompra'] ?></td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
													<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<li>
														<a href="#!" class="dropdown-item datos-hardware" data-bs-toggle="modal" data-bs-target="#informacionHardware" data-id="<?= $items['IDHardware'] ?>" data-accion="ver" id="ver-hardware">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<?php
													if (in_array("UPDHAR", $permisos)) 
													{
													?>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-hardware" data-bs-toggle="modal" data-bs-target="#informacionHardware" data-id="<?= $items['IDHardware'] ?>" data-accion="editar" id="editar-hardware">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>
													<?php
													}
													?>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Información Hardware -->
<div class="modal fade" id="informacionHardware" role="dialog" aria-labelledby="exampleinformacionHardware" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="exampleinformacionHardware">Información de hardware</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formInformacionHardware" class="formulario form-steps" autocomplete="off" action="" method="POST">
				<span class="respuesta"></span>
				<div class="modal-body">
					<input type="hidden" id="txtIDHardware_i" name="txtIDHardware_i">
                    <!--<div class="text-center pt-3 pb-4 mb-1 d-flex justify-content-center">
                        <img src="assets/images/logo-dark.png" class="card-logo card-logo-dark" alt="logo dark" height="17">
                        <img src="assets/images/logo-light.png" class="card-logo card-logo-light" alt="logo light" height="17">
                    </div>-->
                    <div class="step-arrow-nav mb-4">
                        <ul class="nav nav-pills custom-nav nav-justified" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="tabInformacionHardware" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionHardware" type="button" role="tab" aria-controls="tabcontentInformacionHardware" aria-selected="true" data-position="0">Información del Hardware</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="tabInformacionCompraHardware" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionCompraHardware" type="button" role="tab" aria-controls="tabcontentInformacionCompraHardware" aria-selected="false" data-position="1">Información de Compra</button>
                            </li>
                        </ul>
                    </div>

                    <div class="tab-content">
                        <div class="tab-pane fade active show" id="tabcontentInformacionHardware" role="tabpanel" aria-labelledby="tabInformacionHardware">
                            <div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtCategoriaHardware_i" class="form-label" >Categoría</label>
            								<input type="text" class="form-control" id="txtCategoriaHardware_i" name="txtCategoriaHardware_i" disabled >
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtTipoHardware_i" class="form-label">Tipo</label>
            								<input type="text" class="form-control" id="txtTipoHardware_i" name="txtTipoHardware_i" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtSubtipoHardware_i" class="form-label">Subtipo</label>
            								<input type="text" class="form-control" id="txtSubtipoHardware_i" name="txtSubtipoHardware_i" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtHostnameHardware_i" class="form-label" style="color: #0A497B;">Hostname</label>
            								<input type="text" class="form-control" style="color: #0A497B; border-color: #0A497B;" id="txtHostnameHardware_i" name="txtHostnameHardware_i">
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtTAGHardware_i" class="form-label">TAG</label>
            								<input type="text" class="form-control" id="txtTAGHardware_i" name="txtTAGHardware_i">
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtSerieHardware_i" class="form-label">Serie</label>
            								<input type="text" class="form-control" id="txtSerieHardware_i" name="txtSerieHardware_i">
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtMarca_i" class="form-label">Marca</label>
            								<select class="form-select" aria-label="Marca" id="txtMarca_i" name="txtMarca_i" data-categoria="HARDWARE">
            									<option selected="" value="">Seleccione una opción</option>
            									
            								</select>
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtModeloComercial_i" class="form-label">Modelo</label>
            								<select class="form-select" aria-label="Modelo" id="txtModeloComercial_i" name="txtModeloComercial_i">
            									<option selected="" value="">Seleccione una opción</option>
            								</select>
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtProcesadorHardware_i" class="form-label">Procesador</label>
            								<select class="form-select" aria-label="Procesador" id="txtProcesadorHardware_i" name="txtProcesadorHardware_i">
            									<option selected="" value="">Seleccione una opción</option>
                								<option value="I5">I5</option>
                								<option value="I7">I7</option>
            								</select>
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtGenProcesadorHardware_i" class="form-label">Generación Procesador</label>
            								<select class="form-select" aria-label="HDD" id="txtGenProcesadorHardware_i" name="txtGenProcesadorHardware_i">
            									<option selected="" value="">Seleccione una opción</option>
                								<option value="4">4ta Generación</option>
                								<option value="5">5ta Generación</option>
                								<option value="6">6ta Generación</option>
                								<option value="7">7ma Generación</option>
                								<option value="8">8va Generación</option>
                								<option value="9">9na Generación</option>
                								<option value="10">10ma Generación</option>
                								<option value="11">11va Generación</option>
                								<option value="12">12va Generación</option>
                								<option value="13">13va Generación</option>
            								</select>
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtRamHardware_i" class="form-label">RAM</label>
            								<select class="form-select" aria-label="RAM" id="txtRamHardware_i" name="txtRamHardware_i">
            									<option selected="" value="">Seleccione una opción</option>
                								<option value="8">8 GB</option>
                								<option value="16">16 GB</option>
                								<option value="32">32 GB</option>
            								</select>
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtTipoRAMHardware_i" class="form-label">Tipo RAM</label>
            								<input type="text" class="form-control" id="txtTipoRAMHardware_i" name="txtTipoRAMHardware_i">
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtHDDHardware_i" class="form-label">HDD</label>
            								<select class="form-select" aria-label="HDD" id="txtHDDHardware_i" name="txtHDDHardware_i">
            									<option selected="" value="">Seleccione una opción</option>
                								<option value="256">256 GB</option>
                								<option value="500">500 GB</option>
                								<option value="512">512 GB</option>
            								</select>
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtSSDHardware_i" class="form-label">SSD</label>
            								<select class="form-select" aria-label="SSD" id="txtSSDHardware_i" name="txtSSDHardware_i">
            									<option selected="" value="">Seleccione una opción</option>
                								<option value="256">256 GB</option>
                								<option value="500">500 GB</option>
                								<option value="512">512 GB</option>
            								</select>
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtPulgadasHardware_i" class="form-label">Pulgadas</label>
            								<select class="form-select" aria-label="Pulgadas" id="txtPulgadasHardware_i" name="txtPulgadasHardware_i">
            									<option selected="" value="">Seleccione una opción</option>
                								<option value="12" data-cat="LAPTOP">12''</option>
                								<option value="14" data-cat="LAPTOP">14''</option>
                								<option value="20" data-cat="MONITOR">20''</option>
                								<option value="22" data-cat="MONITOR">22''</option>
                								<option value="24" data-cat="MONITOR">24''</option>
                								<option value="27" data-cat="MONITOR">27''</option>
            								</select>
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtInicioGarantia_i" class="form-label">Inicio Garantía</label>
            								<input type="date" class="form-control" id="txtInicioGarantia_i" name="txtInicioGarantia_i" value="<?= date("Y-m-d") ?>">
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtFinalGarantia_i" class="form-label">Final Garantía</label>
            								<input type="date" class="form-control" id="txtFinalGarantia_i" name="txtFinalGarantia_i">
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtFinalVidaUtil_i" class="form-label">Final Vida Útil</label>
            								<input type="date" class="form-control" id="txtFinalVidaUtil_i" name="txtFinalVidaUtil_i" style="pointer-events: none; background:#AAA; color:#F5F5F5;">
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-12 col-md-12 col-12 mb-3">
            							<div>
            								<label for="txtDetalleHardware_i" class="form-label">Detalle</label>
            								<textarea class="form-control" id="txtDetalleHardware_i" name="txtDetalleHardware_i" rows="4"></textarea>
            							</div>
            						</div>
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabInformacionCompraHardware"><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Ingresar información de compra</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                        <div class="tab-pane fade" id="tabcontentInformacionCompraHardware" role="tabpanel" aria-labelledby="tabInformacionCompraHardware">
                            <div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-6 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtAlbaranHardware_i" class="form-label" style="color: #F03687;">Código Albarán</label>
            								<input type="text" class="form-control" style="color: #F03687; border-color: #F03687;" id="txtAlbaranHardware_i" name="txtAlbaranHardware_i">
            							</div>
            						</div>
        					        <div class="col-xxl-6 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtDireccionReserva_i" class="form-label">Dirección Reserva</label>
            								<select class="form-select" aria-label="Dirección Reserva" id="txtDireccionReserva_i" name="txtDireccionReserva_i">
            									<option selected="" value="">Seleccione una opción</option>
            								</select>
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-6 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtAreaReserva_i" class="form-label">Área Reserva</label>
            								<select class="form-select" aria-label="Área Reserva" id="txtAreaReserva_i" name="txtAreaReserva_i">
            									<option selected="" value="">Seleccione una opción</option>
            								</select>
            							</div>
            						</div>
        					        <div class="col-xxl-6 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtSubareaReserva_i" class="form-label">Subárea Reserva</label>
            								<select class="form-select" aria-label="Subárea Reserva" id="txtSubareaReserva_i" name="txtSubareaReserva_i">
            									<option selected="" value="">Seleccione una opción</option>
            								</select>
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-6 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtFacturaHardware_i" class="form-label">Nro Factura</label>
            								<input type="text" class="form-control" id="txtFacturaHardware_i" name="txtFacturaHardware_i">
            							</div>
            						</div>
        					        <div class="col-xxl-6 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtOCHardware_i" class="form-label">Nro OC</label>
            								<input type="text" class="form-control" id="txtOCHardware_i" name="txtOCHardware_i">
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-5 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtFechaCompra_i" class="form-label">Fecha Compra</label>
            								<input type="date" class="form-control" id="txtFechaCompra_i" name="txtFechaCompra_i" value="<?= date("Y-m-d") ?>">
            							</div>
            						</div>
            						<div class="col-xxl-2 col-md-12 col-12 px-3">
                            		    <label class="form-label">Moneda Compra</label>
                            			<select class="form-select" aria-label="Moneda de Compra" id="txtMonedaCompraHardware_i" name="txtMonedaCompraHardware_i">
        									<option value="PEN" >Soles (S/)</option>
        									<option value="EUR" >Euros (€)</option>
        									<option value="USD" >Dólares americanos ($)</option>
        								</select>
                            		</div>
            						<div class="col-xxl-5 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtPrecioCompra_i" class="form-label">Precio Compra</label>
            								<input type="number" class="form-control" step="0.01" id="txtPrecioCompra_i" name="txtPrecioCompra_i">
            							</div>
            						</div>
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-light btn-label previestab" data-previous="tabInformacionHardware"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar a información del hardware</button>
                                <button type="submit" class="btn btn-success btn-label right ms-auto"><i class="mdi mdi-content-save label-icon align-middle fs-16 ms-2"></i>Guardar</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                    </div>
                    <!-- end tab content -->
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Subir CSV -->
<div class="modal fade bd-example-modal-lg" id="subirCSVHardware" role="dialog" aria-labelledby="examplesubirCSVHardware" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="examplesubirCSVHardware">Subir CSV de Hardware</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formSubirCSVHardware" autocomplete="off" action="<?= $baseUrl ?>/subir-csv-hardware" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<p>1.- Las fechas deben contar con el formato "YYYY-MM-DD".</p>
						<p>2.- Los valores de monedas deben ser enteros (no 3,999 para indicar 3999) y solo usar punto(.) para separar enteros de decimales (3999.99).</p>
						<p>3.- Evitar espacios en blanco al inicio y al final del campo</p>
						<p>4.- Información de columna [MODELO]: Debe colocarse el nombre exactamente como está en la base de datos, para que se pueda asociar correctamente.</p>
						<p>5.- Información de columna [GENERACIÓN PROCESADOR]: Solo colocar el número de la generación (5, 7, 10, etc).</p>
						<p>6.- Información de columna [RAM]: Solo colocar el valor número de la capacidad de la RAM (4, 8, 16, 32, etc).</p>
						<p>7.- Información de columna [UNIDAD RAM]: [MB, GB, TB]</p>
						<p>8.- Información de columna [PULGADAS]: Si es un equipo ALL IN ONE y/o LAPTOP, debe considerar colocar este campo.</p>
						<p>9.- Información de columna [PRECIO COMPRA]: Considerar colocar el precio de compra para tenerlo como referencia en la asignación y/o reposición.</p>
						<p>10.- Información de columna [USUARIO]: Considerar el usuario asignado al trabajador.</p>
						<p>11.- Información de columna [TIPO ASIGNADO]: [ASIGNADO, TEMPORAL].</p>
						<p style="color: red;">Si deja vacío la columna [USUARIO ASIGNADO], no se va a realizar la asignación.</p>
					</div>
					<div class="col-12 mb-3 d-flex justify-content-end">
						
							<a class='btn btn-success border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/docs/Plantillas/plantilla csv hardware.csv' ?>' download='Plantilla CSV Hardware'>Descargar Plantilla</a>
						
					</div>
					<div class="mb-3">
						<label for="fileCSVHardware" class="form-label">Seleccione CSV:</label>
						<input class="form-control" type="file" id="fileCSVHardware" name="fileCSVHardware">
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>