<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div>
                                <?php
								if (in_array("CSVASI", $permisos)) 
								{
								?>
								<button class="btn btn-success datos-linea" data-bs-toggle="modal" data-bs-target="#subirCSVAsignacion">
									<i class="mdi mdi-file-upload" style="font-size: 18px;"></i> Subir CSV
								</button>
								<?php
								}
								
								if (in_array("ASIDIS", $permisos)) 
								{
								?>
								<a class="btn btn-primary" href="<?= $baseUrl ?>/nueva-asignacion" >
									<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Asignar dispositivos
								</a>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="example" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Matrícula</th>
										<th class="text-center align-middle">Asignado</th>
										<th class="text-center align-middle">Fecha Asignado</th>
										<th class="text-center align-middle">Tipo Asignado</th>
										<th class="text-center align-middle">Observación</th>
										<th class="text-center align-middle">Remitente</th>
										<th class="text-center align-middle">Dispositivos Asignados</th>
										<th class="text-center align-middle">¿Firmado?</th>
										<th class="text-center align-middle">Acción</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listaAsignaciones as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDAsignacion'] ?></td>
										<td class="text-center align-middle"><?= $items['MatriculaAsignado'] ?></td>
										<td class="text-center align-middle"><?= $items['NombreAsignado'] ?></td>
										<td class="text-center align-middle"><?= date("d-m-Y", strtotime($items['FechaAsignado'])) ?></td>
										<td class="text-center align-middle"><?= $items['TipoAsignado'] ?></td>
										<td class="text-center align-middle"><?= $items['Observacion'] ?></td>
										<td class="text-center align-middle"><?= $items['NombreRemitente'] ?></td>
										<td class="text-center align-middle"><?= $items['TIPOS_ELEMENTO'] ?></td>
										<td class="text-center align-middle">
											<?php
											if($items['FechaRegistroFirma']!='' && $items['FechaRegistroFirma']!=null)
											{
											?>
											<span class="badge bg-success border-0"><?= date("d-m-Y H:i:s", strtotime($items['FechaRegistroFirma'])) ?></span>
											<?php
											}
											else
											{
											?>
											<span class="badge bg-danger border-0">NO</span>
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
													<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<!--<li>
														<a href="#!" class="dropdown-item datos-operador" data-bs-toggle="modal" data-bs-target="#informacionOperador" data-id="<?= $items['UsuarioAsignado'] ?>" data-accion="ver" id="ver-operador">
															<i class="ri-eye-fill align-bottom me-2 text-muted"></i> Ver
														</a>
													</li>
													<li>
														<a href="#!" class="dropdown-item edit-item-btn datos-operador" data-bs-toggle="modal" data-bs-target="#informacionOperador" data-id="<?= $items['UsuarioAsignado'] ?>" data-accion="editar" id="editar-operador">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Editar
														</a>
													</li>-->
													<?php
													if (in_array("VIEDOC", $permisos)) 
													{
													?>
													<li>
														<a href="<?= $baseUrl ?>/documento-asignado/<?= $items['IDAsignacion'] ?>" class="dropdown-item">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Documento
														</a>
													</li>
													<?php
													}

													if (in_array("DETASI", $permisos)) 
													{
													?>
													<li>
														<a href="<?= $baseUrl ?>/detalle-acta-asignacion/<?= $items['IDAsignacion'] ?>" class="dropdown-item">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Ver Detalle
														</a>
													</li>
													<?php
													}
													?>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Subir CSV -->
<div class="modal fade bd-example-modal-lg" id="subirCSVAsignacion" tabindex="-1" role="dialog" aria-labelledby="examplesubirCSVAsignacion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="examplesubirCSVAsignacion">Subir CSV de Asignación</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formSubirCSVAsignacion" autocomplete="off" action="<?= $baseUrl ?>/subir-csv-asignacion" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<p>1.- Las fechas deben contar con el formato "YYYY-MM-DD".</p>
						<p>2.- Evitar espacios en blanco al inicio y al final del campo</p>
						<p>3.- Información de columna [TIPO]: [LINEA, MOVIL]</p>
						<p>4.- Información de columna [REFERENCIA]: Colocar el número de la línea si el tipo es LINEA, o colocar el IMEI si el tipo es MOVIL.</p>
						<p>5.- Información de columna [USUARIO]: Considerar el usuario asignado al trabajador.</p>
						<p>6.- Información de columna [TIPO ASIGNADO]: [ASIGNADO, TEMPORAL].</p>
						<p>7.- Información de columna [OBSERVACION ASIGNADO]: Observación general de la asignación.</p>
						<p>8.- Información de columna [OBSERVACION ELEMENTO]: Observación particular del elemento que se va a asignar.</p>
					</div>
					<div class="col-12 mb-3 d-flex justify-content-end">
						
							<a class='btn btn-success border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/docs/Plantillas/plantilla csv asignaciones.csv' ?>' download='Plantilla CSV Asignaciones'>Descargar Plantilla</a>
						
					</div>
					<div class="mb-3">
						<label for="fileCSVAsignacion" class="form-label">Seleccione CSV:</label>
						<input class="form-control" type="file" id="fileCSVAsignacion" name="fileCSVAsignacion">
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>