<?= $this->extend('estructura/header_dashboard'); ?>
<?= $this->section('content'); ?>
<!-- ============================================================== -->
<!-- Start right Content here -->
<!-- ============================================================== -->
<div class="main-content">
	<div class="page-content">
		<div class="container-fluid">
			<!-- start page title -->
			<div class="row">
				<div class="col-12">
					<div class="page-title-box d-sm-flex align-items-center justify-content-between">
						<h4 class="mb-sm-0"><?= $breadcrumb_alias ?></h4>
						<div class="page-title-right">
							<ol class="breadcrumb m-0">
								<li class="breadcrumb-item"><a href="javascript: void(0);">Inicio</a></li>
								<li class="breadcrumb-item active"><?= $breadcrumb_alias ?></li>
							</ol>
						</div>
					</div>
				</div>
			</div>
			<!-- end page title -->
			<div class="row">
				<div class="col-lg-12">
					<div class="card">
						<div class="card-header d-flex align-items-center">
                            <h5 class="card-title mb-0 flex-grow-1"><?= $breadcrumb_alias ?></h5>
                            <div class="d-flex">
                                <?php
								if (in_array("CSVASI", $permisos)) 
								{
								?>
								<button class="btn btn-success d-flex justify-content-start align-items-center me-2" data-bs-toggle="modal" data-bs-target="#subirCSVAsignacion">
									<i class="mdi mdi-file-upload me-1" style="font-size: 18px;"></i> Subir CSV
								</button>
								<?php
								}
								
								if (in_array("ASIDIS", $permisos)) 
								{
								?>
								<button class="btn btn-primary d-flex justify-content-start align-items-center" data-bs-toggle="modal" data-bs-target="#nuevaAsignacion" id="btnNuevaAsignacion">
									<i class="mdi mdi-plus-circle align-bottom me-1" style="font-size: 18px;"></i> Asignar
								</button>
								<?php
								}
								?>
                            </div>
                        </div>
						<div class="card-body">
							<table id="example" class="table table-bordered dt-responsive nowrap table-striped align-middle" style="width:100%">
								<thead>
									<tr>
										<th class="text-center align-middle">Código</th>
										<th class="text-center align-middle">Matrícula</th>
										<th class="text-center align-middle">Asignado</th>
										<th class="text-center align-middle">Fecha Asignado</th>
										<th class="text-center align-middle">Tipo Asignado</th>
										<th class="text-center align-middle">Observación</th>
										<!--<th class="text-center align-middle">Remitente</th>-->
										<th class="text-center align-middle">Dispositivos Asignados</th>
										<th class="text-center align-middle">¿Firmado?</th>
										<th class="text-center align-middle">Acción</th>
									</tr>
								</thead>
								<tbody>
									<?php 
									foreach($listaAsignaciones as $items){ ?>
									<tr>
										<td class="text-center align-middle"><?= $items['IDAsignacion'] ?></td>
										<td class="text-center align-middle"><?= $items['MatriculaAsignado'] ?></td>
										<td class="text-center align-middle"><?= $items['NombreAsignado'] ?></td>
										<td class="text-center align-middle"><?= date("d-m-Y", strtotime($items['FechaAsignado'])) ?></td>
										<td class="text-center align-middle"><?= $items['TipoAsignado'] ?></td>
										<td class="text-center align-middle"><?= $items['Observacion'] ?></td>
										<!--<td class="text-center align-middle"><?= $items['NombreRemitente'] ?></td>-->
										<td class="text-center align-middle"><?= $items['TIPOS_ELEMENTO'] ?></td>
										<td class="text-center align-middle">
											<?php
											if($items['FechaRegistroFirma']!='' && $items['FechaRegistroFirma']!=null)
											{
											?>
											<span class="badge bg-success border-0"><?= date("d-m-Y H:i:s", strtotime($items['FechaRegistroFirma'])) ?></span>
											<?php
											}
											else
											{
											?>
											<span class="badge bg-danger border-0">NO</span>
											<?php
											}
											?>
										</td>
										<td class="text-center align-middle">
											<div class="dropdown d-inline-block">
												<button class="btn btn-soft-secondary btn-sm dropdown" type="button" data-bs-toggle="dropdown" aria-expanded="false">
													<i class="ri-more-fill align-middle"></i>
												</button>
												<ul class="dropdown-menu dropdown-menu-end">
													<?php
													if (in_array("VIEDOC", $permisos)) 
													{
													?>
													<li>
														<a href="<?= $baseUrl ?>/documento-asignado/<?= $items['IDAsignacion'] ?>" class="dropdown-item">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Documento
														</a>
													</li>
													<?php
													}

													if (in_array("DETASI", $permisos)) 
													{
													?>
													<li>
														<a href="<?= $baseUrl ?>/detalle-acta-asignacion/<?= $items['IDAsignacion'] ?>" class="dropdown-item">
															<i class="ri-pencil-fill align-bottom me-2 text-muted"></i> Ver Detalle
														</a>
													</li>
													<?php
													}
													?>
												</ul>
											</div>
										</td>
									</tr>
									<?php } ?>
								</tbody>
							</table>
						</div>
					</div>
				</div>
			</div>
		</div>
		<span class="respuesta_global"></span>
		<!-- container-fluid -->
	</div>
	<!-- End Page-content -->
	<footer class="footer">
		<div class="container-fluid">
			<div class="row">
				<div class="col-sm-6">
					<script>document.write(new Date().getFullYear())</script> © Verisure Peru.
				</div>
				<div class="col-sm-6">
					<div class="text-sm-end d-none d-sm-block">
						Desarrollado por <a href="https://linktr.ee/rbarcenac">Verisure Peru</a>
					</div>
				</div>
			</div>
		</div>
	</footer>
</div>
<!-- end main content-->
<!-- Modal Información Hardware -->
<div class="modal fade zoomIn" id="nuevaAsignacion" data-bs-backdrop="static" role="dialog" aria-labelledby="examplenuevaAsignacion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content" style="border: none;">
			<div class="modal-header bg-sistema p-3">
				<h5 class="modal-title color-white" id="examplenuevaAsignacion">Nueva Asignación</h5>
				<button type="button" class="btn-close bg-white" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form id="formNuevaAsignacionURES" class="formulario form-steps" autocomplete="off" action="<?= $baseUrl ?>/guardar-asignacion" method="POST" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
                    <div class="step-arrow-nav mb-4">
                        <ul class="nav nav-pills custom-nav nav-justified" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="tabInformacionAsignacion" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionAsignacion" type="button" role="tab" aria-controls="tabcontentInformacionAsignacion" aria-selected="true" data-position="0">Asignación</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="tabInformacionElementos" data-bs-toggle="pill" data-bs-target="#tabcontentInformacionElementos" type="button" role="tab" aria-controls="tabcontentInformacionElementos" aria-selected="false" data-position="1">Elementos de la asignación</button>
                            </li>
                        </ul>
                    </div>

                    <div class="tab-content">
                        <div class="tab-pane fade active show" id="tabcontentInformacionAsignacion" role="tabpanel" aria-labelledby="tabInformacionAsignacion">
                            <div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-8 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Usuario Remitente</label>
            								<input type="text" class="form-control" value="<?= $nombres.' '.$apellidos ?>" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label class="form-label" >Matrícula Remitente</label>
            								<input type="text" class="form-control" value="<?= $matriculaLog ?>" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-6 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtFechaAsignado" class="form-label">Fecha de asignación</label>
            								<input type="date" class="form-control validarNextTab" id="txtFechaAsignado" name="txtFechaAsignado" value="<?= date("Y-m-d") ?>">
            							</div>
            						</div>
            						<div class="col-xxl-6 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtTipoAsignado" class="form-label">Tipo de asignación</label>
            								<select class="form-select validarNextTab" aria-label="Tipo de asignación" id="txtTipoAsignado" name="txtTipoAsignado">
            									<option selected="" value="">Seleccione una opción</option>
                								<option value="ASIGNADO">ASIGNADO</option>
                								<option value="TEMPORAL">TEMPORAL</option>
            								</select>
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-12 col-md-12 col-12 mb-3">
            							<div>
            								<label for="txtObservacionAsignacion" class="form-label">Observación</label>
            								<textarea class="form-control" id="txtObservacionAsignacion" name="txtObservacionAsignacion" rows="4"></textarea>
            							</div>
            						</div>
        					    </div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-12 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtUsuarioAsignacion" class="form-label">Seleccione asignado</label>
            								<select class="form-select validarNextTab" aria-label="Usuario Asignado" id="txtUsuarioAsignacion" name="txtUsuarioAsignacion">
            									<option selected="" value="">Seleccione una opción</option>
            								</select>
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtNombreAsignado" class="form-label" >Nombre Usuario</label>
            								<input type="text" class="form-control validarNextTab" id="txtNombreAsignado" name="txtNombreAsignado" disabled >
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtApellidoAsignado" class="form-label">Apellido Usuario</label>
            								<input type="text" class="form-control validarNextTab" id="txtApellidoAsignado" name="txtApellidoAsignado" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtDocumentoAsignado" class="form-label">Documento Usuario</label>
            								<input type="text" class="form-control validarNextTab" id="txtDocumentoAsignado" name="txtDocumentoAsignado" disabled >
            							</div>
            						</div>
        					    </div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtDireccionAsignado" class="form-label" >Dirección Usuario</label>
            								<input type="text" class="form-control validarNextTab" id="txtDireccionAsignado" name="txtDireccionAsignado" disabled >
            							</div>
            						</div>
        					        <div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtAreaAsignado" class="form-label">Área Usuario</label>
            								<input type="text" class="form-control validarNextTab" id="txtAreaAsignado" name="txtAreaAsignado" disabled >
            							</div>
            						</div>
            						<div class="col-xxl-4 col-md-12 col-12 px-3">
            							<div>
            								<label for="txtCargoAsignado" class="form-label">Cargo Usuario</label>
            								<input type="text" class="form-control validarNextTab" id="txtCargoAsignado" name="txtCargoAsignado" disabled >
            							</div>
            						</div>
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-success btn-label right ms-auto nexttab nexttab" data-nexttab="tabInformacionElementos" id="btnNextTab" disabled><i class="ri-arrow-right-line label-icon align-middle fs-16 ms-2"></i>Ingresar elementos</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                        <div class="tab-pane fade" id="tabcontentInformacionElementos" role="tabpanel" aria-labelledby="tabInformacionElementos">
                            <div>
                                <div class="row col-12 m-0 p-0 mb-3 d-flex">
        					        <div class="col-xxl-5 col-md-12 col-12 px-3">
            							<div>
                                            <label for="txtElementoNuevaAsignacion" class="form-label">Elemento</label>
                                            <select class="form-select" aria-label="Elemento" id="txtElementoNuevaAsignacion" name="txtElementoNuevaAsignacion">
                                                <option selected="" value="">Seleccione una opción</option>
                                                <option value="LINEA">LINEA</option>
                                                <option value="MOVIL">MÓVIL</option>
                                                <option value="TARJETA">TARJETA DE ACCESO</option>
                                                <option value="HARDWARE">HARDWARE</option>
                                                <option value="ACCESORIOIT">ACCESORIOS IT</option>
                                                <option value="KITDEMO">KIT DEMO</option>
                                            </select>
                                        </div>
            						</div>
        					        <div class="col-xxl-5 col-md-12 col-12 px-3">
            						    <div>
            								<label for="txtItem" class="form-label">Item</label>
                                            <select class="form-select" aria-label="Item" id="txtItem" name="txtItem">
                                                <option selected="" value="">Seleccione una opción</option>
                                            </select>
            							</div>
            						</div>
            						<div class="col-xxl-2 col-md-12 col-12 px-3 d-flex justify-content-end align-items-center">
            						    <button type="button" class="btn bg-success px-2 py-1 ms-3" onclick="return agregarItemAsignacion();" data-tooltip="tooltip" aria-label="Agregar Item a la asignación">
                                            <i class="mdi mdi-plus" style="font-size: 24px; color: #FFF"></i>
                                        </button>
            						</div>
        					    </div>
                                <div class="col-xxl-12 col-md-12 col-12 bg-sistema color-white p-3 mb-3 d-flex justify-content-between align-items-center" style="border-radius: 10px; font-size: 15px;">
            					    Elementos para asignar
            					</div>
        					    <div class="row col-12 m-0 p-0 mb-3 d-flex" id="ctnElementosAsignacion">
            						
        					    </div>
                            </div>
                            <div class="d-flex align-items-start gap-3 mt-4">
                                <button type="button" class="btn btn-light btn-label previestab" data-previous="tabInformacionAsignacion"><i class="ri-arrow-left-line label-icon align-middle fs-16 me-2"></i> Regresar a la asignación</button>
                                <button type="submit" class="btn btn-success btn-label right ms-auto"><i class="mdi mdi-content-save label-icon align-middle fs-16 ms-2"></i>Guardar</button>
                            </div>
                        </div>
                        <!-- end tab pane -->
                    </div>
                    <!-- end tab content -->
				</div>
			</form>
		</div>
	</div>
</div>

<!-- Modal Subir CSV -->
<div class="modal fade bd-example-modal-lg" id="subirCSVAsignacion" tabindex="-1" role="dialog" aria-labelledby="examplesubirCSVAsignacion" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="examplesubirCSVAsignacion">Subir CSV de Asignación</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<form class="formulario" id="formSubirCSVAsignacion" autocomplete="off" action="<?= $baseUrl ?>/subir-csv-asignacion" method="POST" enctype="multipart/form-data" accept-charset="utf-8">
				<span class="respuesta"></span>
				<div class="modal-body">
					<div class="col-12 mb-3">
						<h4>Consideraciones:</h4>
						<p>1.- Las fechas deben contar con el formato "YYYY-MM-DD".</p>
						<p>2.- Evitar espacios en blanco al inicio y al final del campo</p>
						<p>3.- Información de columna [TIPO]: [LINEA, MOVIL]</p>
						<p>4.- Información de columna [REFERENCIA]: Colocar el número de la línea si el tipo es LINEA, o colocar el IMEI si el tipo es MOVIL.</p>
						<p>5.- Información de columna [USUARIO]: Considerar el usuario asignado al trabajador.</p>
						<p>6.- Información de columna [TIPO ASIGNADO]: [ASIGNADO, TEMPORAL].</p>
						<p>7.- Información de columna [OBSERVACION ASIGNADO]: Observación general de la asignación.</p>
						<p>8.- Información de columna [OBSERVACION ELEMENTO]: Observación particular del elemento que se va a asignar.</p>
					</div>
					<div class="col-12 mb-3 d-flex justify-content-end">
						
							<a class='btn btn-success border-0 texto-indicador' style="color: #FFF" href='<?= base_url().'/public/docs/Plantillas/plantilla csv asignaciones.csv' ?>' download='Plantilla CSV Asignaciones'>Descargar Plantilla</a>
						
					</div>
					<div class="mb-3">
						<label for="fileCSVAsignacion" class="form-label">Seleccione CSV:</label>
						<input class="form-control" type="file" id="fileCSVAsignacion" name="fileCSVAsignacion">
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
					<button type="submit" class="btn btn-primary"><i class="mdi mdi-content-save"></i> Guardar</button>
				</div>
			</form>
		</div>
	</div>
</div>
<?php $this->endSection(); ?>