<?php
namespace App\Models;
use CodeIgniter\Model;

class VALineasSeguroMovilesModel extends Model
{
    protected $table      = 'lineas_seguro_moviles';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDSeguro', 'IDMovil', 'FechaCompra', 'UsuarioRegistra', 'FechaRegistra'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listadoMovilesXSeguro($idSeguro)
    {
        $this->select('
        lineas_seguro_moviles.IDSeguro,
        lineas_seguro_moviles.IDMovil,
        moviles.Marca,
        moviles.ModeloComercial,
        moviles.IMEI,
            lineas_seguro_moviles.FechaCompra');
        $this->join('moviles', 'lineas_seguro_moviles.IDMovil = moviles.IDMovil', 'left');
        $this->where('lineas_seguro_moviles.IDSeguro', $idSeguro);

        $datos = $this->findAll();
        return $datos;
    }
}