<?php
namespace App\Models;
use CodeIgniter\Model;

class VALineasModel extends Model
{
    protected $table      = 'lineas';
    protected $primaryKey = 'IDLinea';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['Numero', 'ICCID', 'FechaEstado', 'UsuarioEstado', 'Estado', 'Situacion', 'MotivoCambio', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listarLineas()
    {
        $this->select('
            lineas.IDLinea,
            lineas.Numero,
            lineas.ICCID,
            operadores.Operador,
            operadores_planes.Plan,
            lineas_contrato.Estado AS "ESTADO_CONTRATO",
            lineas.Estado AS "ESTADO_LINEA",
            asignacion.UsuarioAsignado');
        $this->join('lineas_contrato', 'lineas.IDLinea = lineas_contrato.IDLinea AND lineas_contrato.Estado = "VIGENTE"', 'left');
        $this->join('operadores_planes', 'lineas_contrato.IDPlan = operadores_planes.IDPlan', 'left');
        $this->join('operadores', 'operadores_planes.IDOperador = operadores.IDOperador', 'left');
        $this->join('(SELECT asignaciones_detalle.IDElemento, asignaciones.UsuarioAsignado FROM asignaciones INNER JOIN asignaciones_detalle ON asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion LEFT JOIN devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion WHERE devoluciones_detalle.IDDevolucion IS NULL AND asignaciones_detalle.TipoElemento="LINEA") AS asignacion', 'lineas.IDLinea = asignacion.IDElemento', 'left');
        //$this->where('lineas_seguro.IDLinea', $idLinea);

        $datos = $this->findAll();
        return $datos;
    }

    public function listadoLineasFiltro($array)
    {
        $this->select('
            lineas.IDLinea,
            lineas.Numero,
            lineas.ICCID,
            operadores.Operador,
            operadores_planes.Plan,
            lineas_contrato.Estado AS "ESTADO_CONTRATO",
            lineas.Estado AS "ESTADO_LINEA",
            asignacion.UsuarioAsignado');
        $this->join('lineas_contrato', 'lineas.IDLinea = lineas_contrato.IDLinea AND lineas_contrato.Estado = "VIGENTE"', 'left');
        $this->join('operadores_planes', 'lineas_contrato.IDPlan = operadores_planes.IDPlan', 'left');
        $this->join('operadores', 'operadores_planes.IDOperador = operadores.IDOperador', 'left');
        $this->join('(SELECT asignaciones_detalle.IDElemento, asignaciones.UsuarioAsignado FROM asignaciones INNER JOIN asignaciones_detalle ON asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion LEFT JOIN devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion WHERE devoluciones_detalle.IDDevolucion IS NULL AND asignaciones_detalle.TipoElemento="LINEA") AS asignacion', 'lineas.IDLinea = asignacion.IDElemento', 'left');
        //$this->where('lineas_seguro.IDLinea', $idLinea);

        if(isset($array['estado']) && $array['estado'] != '' && $array['estado'] != null)
        {
            $this->where('lineas.Estado', $array['estado']);
        }
        
        if(isset($array['libre']) && $array['libre'] == 'Y')
        {
            $this->where('asignacion.UsuarioAsignado IS NULL');
        }
        
        $datos = $this->findAll();
        return $datos;
    }

    public function obtenerLinea($idLinea)
    {
        $this->select('
            lineas.IDLinea,
            lineas.Numero,
            lineas.ICCID,
            operadores.Operador,
            operadores_planes.Plan,
            lineas_contrato.Estado AS "ESTADO_CONTRATO",
            lineas.Estado AS "ESTADO_LINEA"');
        $this->join('lineas_contrato', 'lineas.IDLinea = lineas_contrato.IDLinea AND lineas_contrato.Estado = "VIGENTE"', 'left');
        $this->join('operadores_planes', 'lineas_contrato.IDPlan = operadores_planes.IDPlan', 'left');
        $this->join('operadores', 'operadores_planes.IDOperador = operadores.IDOperador', 'left');
        $this->where('lineas.IDLinea', $idLinea);

        $datos = $this->first();
        return $datos;
    }

    public function listarLineasDisponibles($variable)
    {
        $consulta = "SELECT 
            lineas.IDLinea, 
            lineas.Numero, 
            operadores_planes.Plan,
            operadores.Operador
        FROM
            lineas 
        INNER JOIN 
            lineas_contrato ON lineas.IDLinea = lineas_contrato.IDLinea
        INNER JOIN 
            operadores_planes ON lineas_contrato.IDPlan = operadores_planes.IDPlan
        INNER JOIN 
            operadores ON operadores_planes.IDOperador = operadores.IDOperador
        WHERE 
            (lineas.Numero LIKE '%".$variable."%' OR operadores_planes.Plan LIKE '%".$variable."%' OR operadores.Operador LIKE '%".$variable."%') AND
            lineas.Estado IN ('ACT', 'SUS') AND 
            lineas_contrato.Estado = 'VIGENTE' AND 
            lineas.IDLinea NOT IN (SELECT 
                    asignaciones_detalle.IDElemento 
                FROM 
                    asignaciones_detalle 
                LEFT JOIN 
                    devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
                WHERE 
                    devoluciones_detalle.IDDevolucion IS NULL AND 
                    asignaciones_detalle.TipoElemento = 'LINEA')";
        
        $obtieneConsulta = $this->db->query($consulta);
        return $obtieneConsulta->getResultArray();
    }
}