<?php
namespace App\Models;
use CodeIgniter\Model;

class VAHardwareModel extends Model
{
    protected $table      = 'hardware';
    protected $primaryKey = 'IDHardware';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDModelo', 'Serie', 'Hostname', 'TAG', 'Procesador', 'GeneracionProcesador', 'RAM', 'TipoRam', 'HDD', 'SSD', 'Pulgadas', 'InicioGarantia', 'FinalGarantia', 'FinalVidaUtil', 'Detalle', 'Albaran', 'IDSubarea', 'Factura', 'OrdenCompra', 'FechaCompra', 'MonedaCompra','PrecioCompra', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listadoHardware($estado)
    {
        $this->select('
            hardware.IDHardware,
            hardware.IDModelo,
            hardware.Hostname,
            marcas_dispositivos.Modelo,
            marcas.Marca,
            subtipo.nombre_subtipo,
            tipo.nombre_tipo,
            categoria.nombre_categoria,
            hardware.Serie,
            hardware.TAG,
            hardware.Procesador,
            hardware.GeneracionProcesador,
            hardware.RAM,
            hardware.TipoRam,
            hardware.HDD,
            hardware.SSD,
            hardware.Pulgadas,
            hardware.InicioGarantia,
            hardware.FinalGarantia,
            hardware.FinalVidaUtil,
            hardware.Detalle,
            hardware.Albaran,
            hardware.IDSubarea,
            hardware.Factura,
            hardware.OrdenCompra,
            hardware.FechaCompra,
            hardware.PrecioCompra,
            hardware.MonedaCompra,
            hardware.Estado,
            asignacion.UsuarioAsignado AS UsuarioAsignado');
        $this->join('marcas_dispositivos', 'hardware.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
        $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        $this->join('(SELECT asignaciones_detalle.IDElemento, asignaciones.UsuarioAsignado FROM asignaciones INNER JOIN asignaciones_detalle ON asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion LEFT JOIN devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion WHERE devoluciones_detalle.IDDevolucion IS NULL AND asignaciones_detalle.TipoElemento="HARDWARE") AS asignacion', 'hardware.IDHardware = asignacion.IDElemento', 'left');
        
        if($estado != '')
        {
            $this->where('hardware.Estado', $estado);
        }
        
        $datos = $this->findAll();
        return $datos;
    }

    public function obtenerHardware($idHardware)
    {
        $this->select('
            hardware.IDHardware,
            hardware.IDModelo,
            hardware.Hostname,
            marcas_dispositivos.Modelo,
            marcas_dispositivos.IDMarca,
            marcas.Marca,
            subtipo.nombre_subtipo,
            subtipo.id_tipo,
            tipo.nombre_tipo,
            tipo.id_categoria,
            categoria.nombre_categoria,
            hardware.Serie,
            hardware.TAG,
            hardware.Procesador,
            hardware.GeneracionProcesador,
            hardware.RAM,
            hardware.TipoRam,
            hardware.HDD,
            hardware.SSD,
            hardware.Pulgadas,
            hardware.InicioGarantia,
            hardware.FinalGarantia,
            hardware.FinalVidaUtil,
            hardware.Detalle,
            hardware.Albaran,
            hardware.IDSubarea,
            dbMASTERUSUARIO.estructura_subarea.IDArea,
            dbMASTERUSUARIO.estructura_area.IDDireccion,
            hardware.Factura,
            hardware.OrdenCompra,
            hardware.FechaCompra,
            hardware.PrecioCompra,
            hardware.MonedaCompra,
            hardware.Estado,
            "" AS UsuarioAsignado');
        $this->join('marcas_dispositivos', 'hardware.IDModelo = marcas_dispositivos.IDDispositivo', 'left');
        $this->join('marcas', 'marcas_dispositivos.IDMarca = marcas.IDMarca', 'left');
        $this->join('subtipo', 'marcas_dispositivos.Subtipo = subtipo.id_subtipo', 'left');
        $this->join('tipo', 'subtipo.id_tipo = tipo.id_tipo', 'left');
        $this->join('categoria', 'tipo.id_categoria = categoria.id_categoria', 'left');
        $this->join('dbMASTERUSUARIO.estructura_subarea', 'hardware.IDSubarea = dbMASTERUSUARIO.estructura_subarea.IDSubarea', 'left');
        $this->join('dbMASTERUSUARIO.estructura_area', 'dbMASTERUSUARIO.estructura_subarea.IDArea = dbMASTERUSUARIO.estructura_area.IDArea', 'left');
        $this->join('dbMASTERUSUARIO.estructura_direccion', 'dbMASTERUSUARIO.estructura_area.IDDireccion = dbMASTERUSUARIO.estructura_direccion.IDDireccion', 'left');
        $this->where('hardware.IDHardware', $idHardware);
        
        $datos = $this->first();
        return $datos;
    }
    
    public function listarHardwareDisponibles($variable, $subarea)
    {
        $consulta = "SELECT 
            hardware.IDHardware,
            hardware.IDModelo,
            hardware.Hostname,
            marcas_dispositivos.Modelo,
            marcas_dispositivos.IDMarca,
            marcas.Marca,
            subtipo.nombre_subtipo,
            tipo.nombre_tipo,
            categoria.nombre_categoria,
            hardware.Serie,
            hardware.TAG,
            hardware.Procesador,
            hardware.GeneracionProcesador,
            hardware.RAM,
            hardware.TipoRam,
            hardware.HDD,
            hardware.SSD,
            hardware.Pulgadas,
            hardware.InicioGarantia,
            hardware.FinalGarantia,
            hardware.FinalVidaUtil,
            hardware.Detalle,
            hardware.Albaran,
            hardware.IDSubarea,
            hardware.Factura,
            hardware.OrdenCompra,
            hardware.FechaCompra,
            hardware.PrecioCompra,
            hardware.MonedaCompra
        FROM 
            hardware 
        INNER JOIN 
            marcas_dispositivos ON hardware.IDModelo = marcas_dispositivos.IDDispositivo 
        INNER JOIN
        	marcas ON marcas_dispositivos.IDMarca = marcas.IDMarca
        LEFT JOIN
            subtipo ON marcas_dispositivos.Subtipo = subtipo.id_subtipo
        LEFT JOIN
            tipo ON subtipo.id_tipo = tipo.id_tipo
        LEFT JOIN
            categoria ON tipo.id_categoria = categoria.id_categoria
        WHERE   
            (marcas_dispositivos.Modelo LIKE '%".$variable."%' OR marcas.Marca LIKE '%".$variable."%' OR subtipo.nombre_subtipo LIKE '%".$variable."%' OR tipo.nombre_tipo LIKE '%".$variable."%' OR categoria.nombre_categoria LIKE '%".$variable."%' OR hardware.Serie LIKE '%".$variable."%' OR hardware.Hostname LIKE '%".$variable."%') AND
            (hardware.IDSubarea = '".$subarea."' OR hardware.IDSubarea = '' OR hardware.IDSubarea IS NULL) AND
            hardware.Estado IN ('ACT') AND 
            hardware.IDHardware NOT IN (SELECT 
                    asignaciones_detalle.IDElemento 
                FROM 
                    asignaciones_detalle 
                LEFT JOIN 
                    devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
                WHERE 
                    devoluciones_detalle.IDDevolucion IS NULL AND 
                    asignaciones_detalle.TipoElemento = 'HARDWARE')";

        $obtieneConsulta = $this->db->query($consulta);
        return $obtieneConsulta->getResultArray();
    }
}