<?php
namespace App\Models;
use CodeIgniter\Model;

class SolicitudReposicionModel extends Model
{
    protected $table      = 'solicitud_reposicion';
    protected $primaryKey = 'IDSolicitudReposicion';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDDetalleAsignacion', 'Observacion', 'AreaEncargada', 'MotivoReposicion', 'IDUsuarioAdjudicado', 'GeneraReposicion', 'DescargoEvaluacion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'IDDireccionEstado', 'IDAreaEstado', 'IDSubareaEstado', 'IDDelegacionEstado', 'IDPerfilEstado', 'IDCargoEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function listarSolicitudesReposicion($array)
    {
        $this->select('solicitud_reposicion.IDSolicitudReposicion,
            solicitud_reposicion.IDDetalleAsignacion, 
            solicitud_reposicion.Observacion, 
            solicitud_reposicion.AreaEncargada, 
            solicitud_reposicion.MotivoReposicion, 
            solicitud_reposicion.IDUsuarioAdjudicado, 
            solicitud_reposicion.UsuarioCrea, 
            asignaciones_detalle.TipoElemento, 
            asignaciones_detalle.IDElemento, 
            solicitud_reposicion.FechaCrea, 
            solicitud_reposicion.FechaModifica,
            solicitud_reposicion.Estado,
            devoluciones_detalle.IDDevolucion');
        $this->join('asignaciones_detalle', 'solicitud_reposicion.IDDetalleAsignacion = asignaciones_detalle.IDDetalleAsignacion', 'left');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion', 'left');
        // $this->where('asignaciones_detalle.IDDetalleAsignacion', $idDetalleAsignacion);

        $datos = $this->findAll();
        return $datos;
    }
    
    public function obtenerSolicitudReposicion($idSolicitud)
    {
        $this->select('solicitud_reposicion.IDSolicitudReposicion,
            solicitud_reposicion.IDDetalleAsignacion, 
            solicitud_reposicion.Observacion, 
            solicitud_reposicion.AreaEncargada, 
            solicitud_reposicion.MotivoReposicion, 
            solicitud_reposicion.IDUsuarioAdjudicado, 
            solicitud_reposicion.GeneraReposicion, 
            solicitud_reposicion.DescargoEvaluacion, 
            solicitud_reposicion.UsuarioCrea, 
            solicitud_reposicion.FechaCrea, 
            asignaciones_detalle.TipoElemento, 
            asignaciones_detalle.IDElemento, 
            solicitud_reposicion.FechaModifica,
            solicitud_reposicion.Estado,
            solicitud_reposicion.FechaEstado,
            devoluciones_detalle.IDDetalleDevolucion,
            devoluciones_detalle.IDDevolucion,
            reposiciones_detalle.IDDetalleReposicion,
            reposiciones_detalle.IDReposicion');
        $this->join('asignaciones_detalle', 'solicitud_reposicion.IDDetalleAsignacion = asignaciones_detalle.IDDetalleAsignacion', 'left');
        $this->join('devoluciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion', 'left');
        $this->join('reposiciones_detalle', 'asignaciones_detalle.IDDetalleAsignacion = reposiciones_detalle.IDDetalleAsignacion', 'left');
        $this->where('solicitud_reposicion.IDSolicitudReposicion', $idSolicitud);

        $datos = $this->first();
        return $datos;
    }
    
}