<?php
namespace App\Models;
use CodeIgniter\Model;

class PaqueteriaDetalleModel extends Model
{
    protected $table      = 'paqueteria_detalle';
    protected $primaryKey = 'IDDetallePaqueteria';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['IDPaqueteria', 'IDDetalleAsignacion', 'Observacion', 'FechaRecepcion', 'ObservacionRecepcion', 'UsuarioRecepcion', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Estado', 'Localhost'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;

    public function validarElementoPaqueteria($id)
    {
        $this->select('paqueteria_detalle.IDDetallePaqueteria');
        $this->where('paqueteria_detalle.IDDetalleAsignacion', $id);

        $datos = $this->findAll();
        return $datos;
    }

    public function listarDetallePaqueteria($idPaqueteria)
    {
        $this->select('paqueteria_detalle.IDDetallePaqueteria, 
        paqueteria_detalle.IDPaqueteria, 
        paqueteria_detalle.IDDetalleAsignacion, 
        paqueteria_detalle.Observacion, 
        asignaciones_detalle.IDDetalleAsignacion, 
        asignaciones_detalle.IDAsignacion, 
        asignaciones.UsuarioAsignado,
        asignaciones_detalle.TipoElemento, 
        asignaciones_detalle.IDElemento');
        $this->join('asignaciones_detalle', 'paqueteria_detalle.IDDetalleAsignacion = asignaciones_detalle.IDDetalleAsignacion', 'left');
        $this->join('asignaciones', 'asignaciones_detalle.IDAsignacion = asignaciones.IDAsignacion', 'left');
        $this->where('paqueteria_detalle.IDPaqueteria', $idPaqueteria);
        
        $datos = $this->findAll();
        return $datos;
    }
    
}