<?php
namespace App\Models;
use CodeIgniter\Model;

class KitsDemoModel extends Model
{
    protected $table      = 'kit_demo';
    protected $primaryKey = 'IDItemKitDemo';

    protected $useAutoIncrement = true;

    protected $returnType     = 'array';
    protected $useSoftDeletes = false;

    protected $allowedFields = ['CodigoKitDemo', 'IDElementoDemo', 'Serie', 'Detalle', 'FechaCompra', 'UsuarioCrea', 'FechaCrea', 'UsuarioModifica', 'FechaModifica', 'Localhost', 'Estado', 'UsuarioEstado', 'FechaEstado', 'MotivoEstado'];

    protected $useTimestamps = false;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;
    
    public function listarKitsDemo($estado)
    {
        $this->select('kit_demo.IDItemKitDemo,
            kit_demo.CodigoKitDemo,
            kit_demo.IDElementoDemo,
            elementos_demo.SKU,
            elementos_demo.Nombre,
            kit_demo.Serie,
            kit_demo.Detalle,
            kit_demo.FechaCompra,
            kit_demo.Estado,
            asignacion.UsuarioAsignado');
        $this->join('elementos_demo', 'kit_demo.IDElementoDemo = elementos_demo.IDElementoDemo', 'left');
        $this->join('(SELECT asignaciones_detalle.IDElemento, asignaciones.UsuarioAsignado FROM asignaciones INNER JOIN asignaciones_detalle ON asignaciones.IDAsignacion = asignaciones_detalle.IDAsignacion LEFT JOIN devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion WHERE devoluciones_detalle.IDDevolucion IS NULL AND asignaciones_detalle.TipoElemento="KITDEMO") AS asignacion', 'kit_demo.IDItemKitDemo = asignacion.IDElemento', 'left');
        
        
        if($estado != '')
        {
            $this->where('kit_demo.Estado', $estado);
        }
        
        $datos = $this->findAll();
        return $datos;
    }

    public function listarKitDemoXCodigoKitXNoAsignado($codigoKitDemo)
    {
        $this->select('kit_demo.IDItemKitDemo,
            kit_demo.CodigoKitDemo,
            kit_demo.IDElementoDemo,
            elementos_demo.SKU,
            elementos_demo.Nombre,
            elementos_demo.PrecioReposicion,
            elementos_demo.MonedaReposicion,
            kit_demo.Serie,
            kit_demo.Detalle,
            kit_demo.FechaCompra,
            kit_demo.Estado');
        $this->join('elementos_demo', 'kit_demo.IDElementoDemo = elementos_demo.IDElementoDemo', 'left');
        $this->where('kit_demo.CodigoKitDemo', $codigoKitDemo);
        $this->where('kit_demo.Estado', "ACT");
        $this->where('kit_demo.IDItemKitdemo NOT IN (SELECT
                    kit_demo.IDItemKitDemo
                FROM 
                    asignaciones_detalle
                INNER JOIN 
                	kit_demo ON asignaciones_detalle.IDElemento = kit_demo.IDItemKitDemo AND asignaciones_detalle.TipoElemento = "KITDEMO"
                LEFT JOIN 
                    devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
                WHERE 
                    devoluciones_detalle.IDDevolucion IS NULL)');
        
        $datos = $this->findAll();
        return $datos;
    }
    
    public function obtenerKitDemoAsignadoUsuario($idUsuario)
    {
        $consulta = "SELECT DISTINCT
            kit_demo.CodigoKitDemo
        FROM 
            asignaciones_detalle
        INNER JOIN 
        	asignaciones ON asignaciones_detalle.IDAsignacion = asignaciones.IDAsignacion
        INNER JOIN 
        	kit_demo ON asignaciones_detalle.IDElemento = kit_demo.IDItemKitDemo AND asignaciones_detalle.TipoElemento = 'KITDEMO'
        LEFT JOIN 
            devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
        WHERE 
            devoluciones_detalle.IDDevolucion IS NULL AND asignaciones.UsuarioAsignado = '".$idUsuario."'";

        $obtieneConsulta = $this->db->query($consulta);
        return $obtieneConsulta->getResultArray();
    }

    public function listarKitDemoDisponibles($variable)
    {
        $consulta = "SELECT DISTINCT
            kit_demo.CodigoKitDemo
        FROM 
            kit_demo
        WHERE   
            (kit_demo.CodigoKitDemo LIKE '%".$variable."%') AND
            kit_demo.Estado IN ('ACT') AND 
            kit_demo.CodigoKitDemo NOT IN (SELECT DISTINCT
                    kit_demo.CodigoKitDemo
                FROM 
                    asignaciones_detalle
                INNER JOIN 
                	kit_demo ON asignaciones_detalle.IDElemento = kit_demo.IDItemKitDemo AND asignaciones_detalle.TipoElemento = 'KITDEMO'
                LEFT JOIN 
                    devoluciones_detalle ON asignaciones_detalle.IDDetalleAsignacion = devoluciones_detalle.IDDetalleAsignacion 
                WHERE 
                    devoluciones_detalle.IDDevolucion IS NULL)";

        $obtieneConsulta = $this->db->query($consulta);
        return $obtieneConsulta->getResultArray();
    }
    
    public function obtenerItemKitDemo($idItemKitDemo)
    {
        $this->select('kit_demo.IDItemKitDemo,
            kit_demo.CodigoKitDemo,
            kit_demo.IDElementoDemo,
            elementos_demo.SKU,
            elementos_demo.Nombre,
            elementos_demo.PrecioReposicion,
            kit_demo.Serie,
            kit_demo.Detalle,
            kit_demo.FechaCompra,
            kit_demo.Estado');
        $this->join('elementos_demo', 'kit_demo.IDElementoDemo = elementos_demo.IDElementoDemo', 'left');
        $this->where('kit_demo.IDItemKitDemo', $idItemKitDemo);

        $datos = $this->first();
        return $datos;
    }

}