<?php

namespace App\Libraries;
use \App\Libraries\Error;
use \App\Libraries\Alertas;

class Globales {
    
    function estadosSolicitud() {
        return array(
            'CREA' => array(
                "PASADO"    => "CREADO",
                "FUTURO"    => "CREAR",
                "FONDO"     => "bg-crea",
                "COLOR"     => "color-crea",
                "ICONO"     => "mdi mdi-creation"
            ),
            'RECI' => array(
                "PASADO"    => "RECIBIDO",
                "FUTURO"    => "RECIBIR",
                "FONDO"     => "bg-asig",
                "COLOR"     => "color-asig",
                "ICONO"     => "mdi mdi-book-arrow-left"
            ),
            'INIC' => array(
                "PASADO"    => "INICIADO",
                "FUTURO"    => "INICIAR",
                "FONDO"     => "bg-inic",
                "COLOR"     => "color-inic",
                "ICONO"     => "mdi mdi-play-circle"
            ),
            'COMP' => array(
                "PASADO"    => "COMPLETADO",
                "FUTURO"    => "COMPLETAR",
                "FONDO"     => "bg-comp",
                "COLOR"     => "color-comp",
                "ICONO"     => "mdi mdi-stop-circle"
            ),
            // 'ASIG' => array(
            //     "PASADO"    => "ASIGNADO",
            //     "FUTURO"    => "ASIGNAR",
            //     "FONDO"     => "bg-asig",
            //     "COLOR"     => "color-asig",
            //     "ICONO"     => "mdi mdi-account-search"
            // ),
            // 'ESPE' => array(
            //     "PASADO"    => "EN ESPERA",
            //     "FUTURO"    => "EN ESPERA",
            //     "FONDO"     => "bg-espe",
            //     "COLOR"     => "color-espe",
            //     "ICONO"     => "mdi mdi-pause-circle"
            // ),
            // 'DERI' => array(
            //     "PASADO"    => "DERIVADO",
            //     "FUTURO"    => "DERIVAR",
            //     "FONDO"     => "bg-deri",
            //     "COLOR"     => "color-deri",
            //     "ICONO"     => "mdi mdi-share-circle"
            // ),
            // 'APRO' => array(
            //     "PASADO"    => "APROBADO",
            //     "FUTURO"    => "APROBAR",
            //     "FONDO"     => "bg-apro",
            //     "COLOR"     => "color-apro",
            //     "ICONO"     => "mdi mdi-check-circle"
            // ),
            // 'REEV' => array(
            //     "PASADO"    => "REEVALUADO",
            //     "FUTURO"    => "REEVALUAR",
            //     "FONDO"     => "bg-reev",
            //     "COLOR"     => "color-reev",
            //     "ICONO"     => "mdi mdi-replay"
            // ),
            // 'AA' => array(
            //     "PASADO"    => "APROBADO AUTOMÁTICO",
            //     "FUTURO"    => "APROBAR AUTOMÁTICAMENTE",
            //     "FONDO"     => "bg-aa",
            //     "COLOR"     => "color-aa",
            //     "ICONO"     => "mdi mdi-check-circle"
            // ),
            // 'CANC' => array(
            //     "PASADO"    => "CANCELADO",
            //     "FUTURO"    => "CANCELAR",
            //     "FONDO"     => "bg-canc",
            //     "COLOR"     => "color-canc",
            //     "ICONO"     => "mdi mdi-cancel"
            // ),
            // 'COME' => array(
            //     "PASADO"    => "COMENTARIO",
            //     "FUTURO"    => "COMENTAR",
            //     "FONDO"     => "bg-come",
            //     "COLOR"     => "color-come",
            //     "ICONO"     => "mdi mdi-comment"
            // )
        );
    }    

    function motivosDevolucion()
    {
        return array(
            "DEV" => "DEVOLUCIÓN OK",
            "FVU" => "BAJA POR FIN DE VIDA ÚTIL",
            "INO" => "INOPERATIVO",
            "ROB" => "ROBO",
            "PER" => "PÉRDIDA",
            "NOD" => "NO DEVOLUCIÓN",
            "FAL" => "FALLA",
            "REN" => "RENOVACIÓN"
        );
    }
    
    function estadosLinea() {
        return array(
            'ACT' => "ACTIVO",
            'SUS' => "SUSPENDIDA",
            'BAJ' => "BAJA"
        );
    }    

    function motivoEstadoLinea($estadoLinea) {

        switch ($estadoLinea) {
            case 'ACT':
                return array(
                    "NUE" => "NUEVO",
                    "REP" => "REPOSICIÓN",
                    "ASI" => "ASIGNADO",
                    "TRA" => "TRASPASO",
                    "DEV" => "DEVOLUCIÓN OK"
                );
                break;
            case 'SUS':
                return array(
                    "ROB" => "ROBO",
                    "PER" => "PÉRDIDA",
                    "BAC" => "BACKUP"
                );
                break;
            case 'BAJ':
                return array(
                    "DEP" => "DEPURACIÓN",
                    "TRA" => "TRASPASO"
                );
                break;
            default:
                return array();
                break;
        }
    }    

    function estadosMovil() {
        return array(
            'ACT' => "ACTIVO",
            'AVE' => "AVERIADO",
            'REP' => "REPARACIÓN",
            'BAJ' => "BAJA"
        );
    }    

    function motivoEstadoMovil($estadoMovil) {

        switch ($estadoMovil) {
            case 'ACT':
                return array(
                    "NUE" => "NUEVO",
                    "OPE" => "OPERATIVO",
                    "ASI" => "ASIGNADO",
                    "STO" => "STOCK",
                    "DEV" => "DEVOLUCIÓN OK"
                );
                break;
            case 'AVE':
                return array(
                    "FF" => "FALLA DE FÁBRICA",
                    "FT" => "FALLA TÉCNICA"
                );
                break;
            case 'REP':
                return array(
                    "GAR" => "GARANTÍA (OPERADOR)",
                    "EXT" => "CENTRO EXTERNO"
                );
                break;
            case 'BAJ':
                return array(
                    "INO" => "INOPERATIVO",
                    "ROB" => "ROBO",
                    "PER" => "PÉRDIDA",
                    "NOD" => "NO DEVOLUCIÓN",
                    "FVU" => "FIN DE VIDA ÚTIL",
                    "FAL" => "FALLA"
                );
                break;
            default:
                return array(
                    "NUE" => "NUEVO",
                    "OPE" => "OPERATIVO",
                    "ASI" => "ASIGNADO",
                    "STO" => "STOCK",
                    "DEV" => "DEVOLUCIÓN OK",
                    "FVU" => "BAJA POR FIN DE VIDA ÚTIL",
                    "FF" => "FALLA DE FÁBRICA",
                    "FT" => "FALLA TÉCNICA",
                    "GAR" => "GARANTÍA (OPERADOR)",
                    "EXT" => "CENTRO EXTERNO",
                    "INO" => "INOPERATIVO",
                    "ROB" => "ROBO",
                    "PER" => "PÉRDIDA",
                    "NOD" => "NO DEVOLUCIÓN",
                    "FAL" => "FALLA"
                );
                break;
        }
    }    

    function permanenciaContrato() {
        return array(
            'SP' => "SIN PERMANENCIA",
            '12' => "12 MESES",
            '15' => "15 MESES",
            '18' => "18 MESES"
        );
    }    

    function estadosPaqueteria() {
        return array(
            'REG' => array(
                "NOMBRE"    => "REGISTRADO",
                "FONDO"     => "bg-secondary"
            ),
            'ENV' => array(
                "NOMBRE"    => "ENVIADO",
                "FONDO"     => "bg-primary"
            ),
            'REC' => array(
                "NOMBRE"    => "RECIBIDO",
                "FONDO"     => "bg-success"
            )
        );
    }    

    function tipoCambioVerisure() {
        return array(
            'PEN' => array(
                "VALORCAMBIO"   => "1",
                "SIMBOLO"       => "S/"
            ),
            'USD' => array(
                "VALORCAMBIO"   => "3.85",
                "SIMBOLO"       => "$"
            ),
            'EUR' => array(
                "VALORCAMBIO"   => "4.20",
                "SIMBOLO"       => "€"
            )
        );
    }    
    
    function diaCortePlanilla()
    {
        return 13;
    }
    
    function listadoCentroCostoCoordinador()
    {
        return array(
            1476 => array(40, 41, 80, 100, 230),
            4093 => array(60, 120, 121, 140, 200),
            1093 => array(152, 154, 155, 158),
            167 => array(130, 150, 151, 156, 157, 159, 252),
            2320 => array(80, 100, 230),
            3998 => array(120, 121),
            4103 => array(120, 140),
            3131 => array(152, 155),
            3298 => array(154),
            1527 => array(156, 157),
            3282 => array(159, 252),
            2319 => array(140, 141),
            112 => array(40, 41, 60, 80, 100, 120, 121, 130, 140, 141, 150, 151, 152, 154, 155, 156, 157, 159, 158, 200, 230, 252)
        );
    }
    
    function perfilesAutorizadosArea()
    {
        return array(
            "URES" => array(1, 5),
            "IT" => array(1, 2)
        );
    }
}
