<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

class Solicitudes extends BaseController
{
	public function __construct(){
	    
        $this->auditoria = new \App\Models\AuditoriaModel();
        
        $this->usuarios = new \App\Models\UsuarioModelo();
        
        $this->elementosDemo = new \App\Models\ElementosDemoModel();
        
        $this->moviles = new \App\Models\VAMovilesModel();
        $this->lineas = new \App\Models\VALineasModel();
        $this->contratos = new \App\Models\VALineasContratoModel();
        $this->tarjetasAcceso = new \App\Models\VATarjetasAccesoModel();
        $this->hardware = new \App\Models\VAHardwareModel();
        $this->kitsDemo = new \App\Models\KitsDemoModel();
        
        $this->estructuraDirecciones = new \App\Models\EstructuraDireccionModel();
        $this->estructuraAreas = new \App\Models\EstructuraAreaModel();
        $this->estructuraSubareas = new \App\Models\EstructuraSubareaModel();
        $this->estructuraDelegaciones = new \App\Models\EstructuraDelegacionModel();
        $this->cargos = new \App\Models\CargosModel();
        
        
        $this->detalleasignaciones = new \App\Models\VAAsignacionesDetalleModel();
        
        $this->solicitudReposicion = new \App\Models\SolicitudReposicionModel();
        
        $this->reposiciones = new \App\Models\VAReposicionesModel();
        $this->reposicionesDetalle = new \App\Models\VAReposicionesDetalleModel();
        $this->reposicionesAdjuntos = new \App\Models\VAReposicionesAdjuntosModel();
        $this->reposicionesCronogramaPago = new \App\Models\VAReposicionesCronogramaPagoModel();
        
        $this->devoluciones = new \App\Models\VADevolucionesModel();
        $this->devolucionesDetalle = new \App\Models\VADevolucionesDetalleModel();
        $this->devolucionesAdjuntos = new \App\Models\VADevolucionesAdjuntosModel();
        
        $this->correoStatusAsignacion = new \App\Models\CorreoStatusAsignacionModel();
        $this->correoStatusDevolucion = new \App\Models\CorreoStatusDevolucionModel();
        $this->correoStatusReposicion = new \App\Models\CorreoStatusReposicionModel();
	}
	
// 	public function insertarNotificacion($array)
// 	{
// 	    $tablaReferencia        = $array['tabla'];
//         $idReferencia           = $array['idreferencia'];
//         $mensaje                = $array['mensaje'];
//         $url                    = $array['url'];
//         $usuarioDestino         = $array['usuariodestino'];
//         $idGrupoTrabajoDestino  = $array['gtdestino'];
//         $idPerfilDestino        = $array['perfildestino'];
//         $usuarioRegistra        = $array['usuarioregistra'];
//         $fechaRegistra          = $array['fecharegistra'];
        
//         $dataNotificacion = array (
//             'TablaReferencia'       => $tablaReferencia, 
//             'IDReferencia'          => $idReferencia,
//             'Mensaje'               => $mensaje, 
//             'URL'                   => $url, 
//             'IDUsuarioDestino'      => $usuarioDestino, 
//             'IDGrupoTrabajoDestino' => $idGrupoTrabajoDestino, 
//             'IDPerfilDestino'       => $idPerfilDestino,
//             'UsuarioRegistra'       => $usuarioRegistra,
//             'FechaRegistra'         => $fechaRegistra
//         );
        
//         $this->notificaciones->insert($dataNotificacion, TRUE);
// 	}
	
	private function devolverInformacionElemento($tipoElemento, $idElemento)
	{
	    $informacion = array();
	    
	    //Obtener elemento
        if($tipoElemento=='MOVIL')
        {
            $dataElemento = $this->moviles->obtenerMovil($idElemento);
            
            $informacion['TIPO'] = $tipoElemento;
            $informacion['Marca'] = $dataElemento['Marca'];
            $informacion['Modelo'] = $dataElemento['Modelo'];
            $informacion['Serie'] = $dataElemento['IMEI'];
            $informacion['NombreCategoria'] = "MOVIL";
        }
        else if($tipoElemento=='LINEA')
        {
            $dataElemento = $this->lineas->obtenerLinea($idElemento);
            
            $informacion['TIPO'] = $tipoElemento.' - '.$dataElemento['Numero'];
            $informacion['Marca'] = $dataElemento['Operador'];
            $informacion['Modelo'] = $dataElemento['Plan'];
            $informacion['Serie'] = $dataElemento['ICCID'];
            $informacion['NombreCategoria'] = "LINEA";
        }
        else if($tipoElemento=='HARDWARE')
        {
            $dataElemento = $this->hardware->obtenerHardware($idElemento);
            
            if($dataElemento['id_categoria'] == '3')
            {
                $informacion['TIPO'] = $dataElemento['nombre_tipo'];
            }
            else
            {
                $informacion['TIPO'] = $dataElemento['nombre_tipo'].' - '.$dataElemento['Hostname'];
            }
            
            $informacion['NombreCategoria'] = $dataElemento['nombre_categoria'];
            $informacion['Marca'] = $dataElemento['Marca'];
            $informacion['Modelo'] = $dataElemento['Modelo'];
            $informacion['Serie'] = $dataElemento['Serie'];
            $informacion['CPU'] = $dataElemento['Procesador'] != '' && $dataElemento['Procesador'] != null && $dataElemento['Procesador'] != '0' ? $dataElemento['Procesador'] : '';
            $informacion['Memoria'] = $dataElemento['RAM'] != '' && $dataElemento['RAM'] != null && $dataElemento['RAM'] != '0' ? $dataElemento['RAM'].' GB' : '';
            // $informacion['DiscoDuro'] = $totalDiscoDuro != null && $totalDiscoDuro != '0' ? $totalDiscoDuro.' GB' : '';
        }
        else if($tipoElemento=='TARJETA')
        {
            $dataElemento = $this->tarjetasAcceso->where("IDTarjetaAcceso", $idElemento)->first();
            
            $informacion['NombreCategoria'] = "TARJETA";
            $informacion['TIPO'] = $tipoElemento;
            $informacion['Marca'] = "--";
            $informacion['Modelo'] = "--";
            $informacion['Serie'] = $dataElemento['Serie'];
        }
        else if($tipoElemento=='KITDEMO')
        {
            $dataElemento = $this->kitsDemo->obtenerItemKitDemo($idElemento);
            
            $informacion['NombreCategoria'] = $tipoElemento;
            $informacion['TIPO'] = 'KIT DEMO - '.$dataElemento['CodigoKitDemo'];
            $informacion['Marca'] = $dataElemento['Nombre'];
            $informacion['Modelo'] = $dataElemento['SKU'];
            $informacion['Serie'] = $dataElemento['Serie'];
        }
        
        return $informacion;
	}
	
	public function listarSolicitudesReposicion()
	{
	    if(isset($this->items['id'])){

			/* ACCIONES */
			
			$listadoSolicitudes = $this->solicitudReposicion->listarSolicitudesReposicion(array());
			$motivosDevolucion = $this->globales->motivosDevolucion();
			$estadosSolicitud = $this->globales->estadosSolicitud();
			
			foreach($listadoSolicitudes as $key=>$value)
            {
                //Obtener Usuario Asignado
			    $adjudicado = $this->usuarios->where("IdUsuario ", $value['IDUsuarioAdjudicado'])->first();
			    $solicitante = $this->usuarios->where("IdUsuario ", $value['UsuarioCrea'])->first();

                $listadoSolicitudes[$key]['NombreAdjudicado'] = strtoupper($adjudicado['Nombres'].' '.$adjudicado['Apellidos']);
                $listadoSolicitudes[$key]['MatriculaAdjudicado'] = $adjudicado['Matricula'];
                $listadoSolicitudes[$key]['NombreSolicitante'] = strtoupper($solicitante['Nombres'].' '.$solicitante['Apellidos']);
                $listadoSolicitudes[$key]['MatriculaSolicitante'] = $solicitante['Matricula'];
                
                $elemento = $this->devolverInformacionElemento($value['TipoElemento'], $value['IDElemento']);
                $listadoSolicitudes[$key]['Elemento'] = $elemento['TIPO'].' | '.$elemento['Marca'].' - '.$elemento['Modelo'].' - '.$elemento['Serie'];
            }

			$data = array (
				'session'               => 'on',
				'titulo'                => 'Solicitudes de Reposición | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Solicitudes de Reposición',
				'listadoSolicitudes'    => $listadoSolicitudes,
				'motivosDevolucion'     => $motivosDevolucion,
				'estadosSolicitud'      => $estadosSolicitud
			);
			$data = array_merge($data, $this->items);
			return view('solicitudes/solicitudes_reposicion',$data);			
		} else {
			return view('errors/500');
		}
	}
	
	
	public function listadoItemsAsignados() {

		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idUsuario = $this->request->getPost('idUsuario');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idUsuario, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$listadoItems = $this->detalleasignaciones->listarDetalleAsignadosUsuario($idUsuario);
        $items = array();

        if (!empty($listadoItems)) {
            foreach($listadoItems as $value)
            {
                $item = $this->devolverInformacionElemento($value['TipoElemento'], $value['IDElemento']);
                $elemento = $item['TIPO'].' | '.$item['Marca'].' '.$item['Modelo'].' '.$item['Serie'];
                
                //Obtener elemento
                // if($value['TipoElemento']=='MOVIL')
                // {
                //     $dataElemento = $this->moviles->obtenerMovil($value['IDElemento']);
                //     $elemento = $value['TipoElemento'].' | '.$dataElemento['IMEI'].' '.$dataElemento['Marca'].' '.$dataElemento['Modelo'];
                // }
                // else if($value['TipoElemento']=='LINEA')
                // {
                //     $dataElemento = $this->lineas->obtenerLinea($value['IDElemento']);
                //     $elemento = $value['TipoElemento'].' | '.$dataElemento['Numero'].' '.$dataElemento['Operador'].' '.$dataElemento['Plan'].' '.$dataElemento['ICCID'];
                // }
                // else if($value['TipoElemento']=='HARDWARE')
                // {
                //     $dataElemento = $this->hardware->obtenerHardware($value['IDElemento']);
                    
                //     if($dataElemento['id_categoria'] == '3')
                //     {
                //         $elemento = $dataElemento['nombre_tipo'].' | '.$dataElemento['Marca'].' '.$dataElemento['Modelo'].' '.$dataElemento['Serie'];
                //     }
                //     else
                //     {
                //         $elemento = $dataElemento['nombre_tipo'].' | '.$dataElemento['Hostname'].' '.$dataElemento['Marca'].' '.$dataElemento['Modelo'].' '.$dataElemento['Serie'];
                //     }
                    
                    
                    

                // }
                // else if($value['TipoElemento']=='TARJETA')
                // {
                //     $dataElemento = $this->tarjetasAcceso->where("IDTarjetaAcceso", $value['IDElemento'])->first();
                //     $elemento = $value['TipoElemento'].' | '.$dataElemento['Serie'];
                // }
                // else
                // {
                //     $elemento = '';
                // }
                
                $items[] = array(
					'id' => (string) $value['IDDetalleAsignacion'],
         	        'item' => (string) $elemento
                );
            }

            
            $resultado = array(
				'listadoItems' => json_encode($items)
			);
        } else {
			$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);		
	}

	
    public function obtenerElementoReponer()
    {
        $idItem = $this->request->getPost('idItem');
        $idUsuario = $this->request->getPost('idUsuario');
        $situacion = $this->request->getPost('situacion');
        
        $dataReposicion = array();
        
        /*
        * ----------------------
        * OBTIENE Y VALIDA DATOS
        * ----------------------
        */
        $detalle = $this->detalleasignaciones->obtenerDetalleAsignacion($idItem);
        
        if($detalle['TipoElemento']=="LINEA")
        {
            $totalDescuento = 1;
            $totalVerisure = 0;
            $totalTrabajador = 1;
            
            $informacionLinea = $this->lineas->obtenerLinea($detalle['IDElemento']);
            
            $dataReposicion[] = array(
                "IDELEMENTO"    => $detalle['IDElemento'],
                "ELEMENTO"      => $detalle['TipoElemento'],
                "IDITEM"        => $idItem,
                "ITEM"          => $informacionLinea['Operador']." - ".$informacionLinea['Numero'].' | '.$informacionLinea['ICCID'],
                "TOTAL"         => 1,
                "MONEDA"        => "PEN",
                "SIMBOLO"       => "S/",
                "VALORCAMBIO"   => "1",
                "TOTALCAMBIO"   => "1",
                "VERISURE"      => "0",
                "TRABAJADOR"    => "1"
            );
        }
        else if($detalle['TipoElemento']=="MOVIL")
        {
            $informacionMovil = $this->moviles->obtenerMovil($detalle['IDElemento']);
            $contrato = $this->contratos->obtenerContratosXEquipo($detalle['IDElemento']);
            
            if($informacionMovil['EquipoStock'] == 'Y' || empty($contrato))
            {
                // $fechaReferencia = $detalle['FechaAsignado'] != '' && $detalle['FechaAsignado'] != null && $detalle['FechaAsignado'] != "0000-00-00" ? $detalle['FechaAsignado'] : $detalle['FechaCrea'];
                $fechaReferencia = "2024-02-16";
                $contrato['Permanencia'] = 'Y';
                $contrato['PrecioCompra'] = $informacionMovil['PrecioCompra'];
                $contrato['MontoCuota'] = number_format(round($informacionMovil['PrecioCompra']/18, 8), 8, '.', '');
                $contrato['DiaFacturacion'] = date("d", strtotime($fechaReferencia."- 1 days"));
                $contrato['PeriodoPermanencia'] = '18';
                $contrato['InicioContrato'] = date("Y-m-d", strtotime($fechaReferencia));
            }
            
            $montoTotal = $this->complementos->calculoPenalidadMovil($contrato);
            $cantidadRobo = $this->detalleasignaciones->obtenerDispositivosRobadosUsuario($idUsuario,"MOVIL");
            $porcentajes = $this->complementos->calculoPorcentajeResponsabilidadMovil(count($cantidadRobo), $montoTotal, $situacion);

            // $totalDescuento = $montoTotal;
            // $totalVerisure = $porcentajes['VERISURE'];
            // $totalTrabajador = $porcentajes['TRABAJADOR'];
            
            $dataReposicion[] = array(
                "IDELEMENTO"    => $detalle['IDElemento'],
                "ELEMENTO"      => $detalle['TipoElemento'],
                "IDITEM"        => $idItem,
                "ITEM"          => $informacionMovil['Marca']." - ".$informacionMovil['Modelo'].' | '.$informacionMovil['IMEI'],
                "TOTAL"         => $montoTotal,
                "MONEDA"        => "PEN",
                "SIMBOLO"       => "S/",
                "VALORCAMBIO"   => "1",
                "TOTALCAMBIO"   => $montoTotal,
                "VERISURE"      => $porcentajes['VERISURE'],
                "TRABAJADOR"    => $porcentajes['TRABAJADOR']
            );
        }
        else if($detalle['TipoElemento']=="HARDWARE")
        {
            $tipoCambio = $this->globales->tipoCambioVerisure();
            
            $informacionHardware = $this->hardware->obtenerHardware($detalle['IDElemento']);
            $montoReposicion = $informacionHardware['PrecioCompra'];
            $valorCambio = $tipoCambio[$informacionHardware['MonedaCompra']]['VALORCAMBIO'];
            
            //SI LA MONEDA ES OTRA QUE NO SEA PEN, DEBE REALIZARSE LA CONVERSIÓN Y AL RESULTADO SETEARLO COMO $montoTotal
            
            if($informacionHardware['MonedaCompra'] != 'PEN')
            {
                $montoTotal = number_format(round($montoReposicion * $valorCambio, 2), 2, '.', '');
            }
            else
            {
                $montoTotal = $montoReposicion;
            }
            
            $cantidadRobo = $this->detalleasignaciones->obtenerDispositivosRobadosUsuario($idUsuario,"HARDWARE");
            $porcentajes = $this->complementos->calculoPorcentajeResponsabilidadMovil(count($cantidadRobo), $montoTotal, $situacion);
            
            if($informacionHardware['id_categoria'] == '3')
            {
                $item = $informacionHardware['nombre_tipo'].' | '.$informacionHardware['Marca'].' - '.$informacionHardware['Modelo'].' | '.$informacionHardware['Serie'];
            }
            else
            {
                $item = $informacionHardware['nombre_tipo'].' | '.$informacionHardware['Marca'].' - '.$informacionHardware['Modelo'].' | '.$informacionHardware['Hostname'].' '.$informacionHardware['Serie'];
            }
            
            $totalDescuento = $montoTotal;
            $totalVerisure = $porcentajes['VERISURE'];
            $totalTrabajador = $porcentajes['TRABAJADOR'];
            
            $dataReposicion[] = array(
                "IDELEMENTO"    => $detalle['IDElemento'],
                "ELEMENTO"      => $detalle['TipoElemento'],
                "IDITEM"        => $idItem,
                "ITEM"          => $item,
                "TOTAL"         => $montoReposicion,
                "MONEDA"        => $informacionHardware['MonedaCompra'],
                "SIMBOLO"       => $tipoCambio[$informacionHardware['MonedaCompra']]['SIMBOLO'],
                "VALORCAMBIO"   => $valorCambio,
                "TOTALCAMBIO"   => $montoTotal,
                "VERISURE"      => $porcentajes['VERISURE'],
                "TRABAJADOR"    => $porcentajes['TRABAJADOR']
            );
        }
        else if($detalle['TipoElemento']=="TARJETA")
        {
            $informacionTarjeta = $this->tarjetasAcceso->where("IDTarjetaAcceso", $detalle['IDElemento'])->first();

            $totalDescuento = $informacionTarjeta['PrecioCompra'];
            $totalVerisure = 0;
            $totalTrabajador = $informacionTarjeta['PrecioCompra'];
            
            $dataReposicion[] = array(
                "IDELEMENTO"    => $detalle['IDElemento'],
                "ELEMENTO"      => $detalle['TipoElemento'],
                "IDITEM"        => $idItem,
                "ITEM"          => $informacionTarjeta['Serie'],
                "TOTAL"         => $informacionTarjeta['PrecioCompra'],
                "MONEDA"        => "PEN",
                "SIMBOLO"       => "S/",
                "VALORCAMBIO"   => "1",
                "TOTALCAMBIO"   => $informacionTarjeta['PrecioCompra'],
                "VERISURE"      => "0",
                "TRABAJADOR"    => $informacionTarjeta['PrecioCompra']
            );
        }
        else if($detalle['TipoElemento'] == "KITDEMO")
        {
            $tipoCambio = $this->globales->tipoCambioVerisure();
            
            $informacionKit = $this->kitsDemo->obtenerItemKitDemo($detalle['IDElemento']);
            $montoReposicion = $informacionKit['PrecioReposicion'];
            $valorCambio = $tipoCambio[$informacionKit['MonedaReposicion']]['VALORCAMBIO'];
            
            //SI LA MONEDA ES OTRA QUE NO SEA PEN, DEBE REALIZARSE LA CONVERSIÓN Y AL RESULTADO SETEARLO COMO $montoTotal
            
            if($informacionKit['MonedaReposicion'] != 'PEN')
            {
                $montoTotal = number_format(round($montoReposicion * $valorCambio, 2), 2, '.', '');
            }
            else
            {
                $montoTotal = $montoReposicion;
            }
            
            $cantidadRobo = $this->detalleasignaciones->obtenerDispositivosRobadosUsuario($idUsuario,"KITDEMO",$detalle['IDElemento']);
            $porcentajes = $this->complementos->calculoPorcentajeResponsabilidadKitDemo(count($cantidadRobo), $montoTotal, $situacion);
            
            $totalDescuento = $montoTotal;
            $totalVerisure = $porcentajes['VERISURE'];
            $totalTrabajador = $porcentajes['TRABAJADOR'];
            
            $dataReposicion[] = array(
                "IDELEMENTO"    => $detalle['IDElemento'],
                "ELEMENTO"      => $detalle['TipoElemento'],
                "IDITEM"        => $idItem,
                "ITEM"          => 'KIT DEMO - '.$informacionKit['CodigoKitDemo'].' | '.$informacionKit['Nombre'].' - '.$informacionKit['SKU'],
                "TOTAL"         => $montoReposicion,
                "MONEDA"        => $informacionKit['MonedaReposicion'],
                "SIMBOLO"       => $tipoCambio[$informacionKit['MonedaReposicion']]['SIMBOLO'],
                "VALORCAMBIO"   => $valorCambio,
                "TOTALCAMBIO"   => $montoTotal,
                "VERISURE"      => $porcentajes['VERISURE'],
                "TRABAJADOR"    => $porcentajes['TRABAJADOR']
            );
        }
        else
        {
            $dataReposicion[] = array(
                "IDELEMENTO"    => "0",
                "ELEMENTO"      => "SIN INFORMACIÓN",
                "IDITEM"        => "0",
                "ITEM"          => "SIN INFORMACIÓN",
                "TOTAL"         => "0",
                "MONEDA"        => "PEN",
                "SIMBOLO"       => "S/",
                "VALORCAMBIO"   => "1",
                "TOTALCAMBIO"   => "0",
                "VERISURE"      => "0",
                "TRABAJADOR"    => "0"
            );
        }
        
        /*
        * ----------------------------
        * ARMAR VISUAL POR ELEMENTO
        * ----------------------------
        */
        
	    $html = '';
	    
	    if(empty($dataReposicion))
	    {
            $aleatorio = $this->complementos->generar_string_aleatorio(5);
    	        
	        $html .= '<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="itemasignar'.$aleatorio.'" style="border-radius: 10px;">
	            <div class="col-xxl-10 col-md-10 col-10 ">
        	        <div class="alert alert-warning alert-border-left alert-dismissible fade show mb-xl-0" role="alert">
                        <i class="ri-error-warning-line me-3 align-middle fs-16"></i><strong>SIN INFORMACIÓN</strong> - No se encontró información sobre el item seleccionado.
                    </div>
                </div>
        		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
        			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico(\'itemasignar'.$aleatorio.'\');" data-tooltip="tooltip" aria-label="Eliminar Item a Asignar">
                        <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                    </button>
        		</div>
        	</div>';
	    }
	    else
	    {
    	    foreach($dataReposicion as $item)
    	    {
                $aleatorio = $this->complementos->generar_string_aleatorio(5);
    	        
    	       // $html.='<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="itemreponer'.$aleatorio.'" style="border-radius: 10px;">
    	       //     <input type="hidden" name="itemReposicion[]" value="'.$item['IDITEM'].'">
    	       //     <input type="hidden" name="elemento['.$aleatorio.']" value="'.$item['ELEMENTO'].'">
    	       //     <input type="hidden" name="etiquetaitem['.$aleatorio.']" value="'.$item['ITEM'].'">
            // 		<div class="col-xxl-7 col-md-12 col-12 mb-2">
            // 			<div>
            // 				<label class="form-label">Elemento:</label>
            // 				<input type="text" class="form-control" value="'.$item['ITEM'].'" disabled>
            // 			</div>
            // 		</div>
            // 		<div class="col-xxl-5 col-md-12 col-12 mb-2">
            // 		    <label class="form-label">Valor Reposición</label>
            // 			<div class="input-group">
            //                 <span class="input-group-text">'.$item['SIMBOLO'].'</span>
            //                 <input type="number" class="form-control" step="0.01" min="0" value="'.$item['TOTAL'].'" disabled>
            //             </div>
            // 		</div>
            // 		<div class="col-xxl-6 col-md-12 col-12 mb-2">
            // 		    <label class="form-label">Tipo de Cambio</label>
            // 			<div class="input-group">
            //                 <span class="input-group-text">S/</span>
            //                 <input type="number" class="form-control" value="'.$item['VALORCAMBIO'].'" disabled>
            //             </div>
            // 		</div>
            		
            // 		<div class="col-xxl-4 col-md-12 col-12 mb-2">
            // 		    <label class="form-label">Total Reposición</label>
            // 			<div class="input-group">
            // 			    <input type="hidden" name="totalDescuento['.$aleatorio.']" value="'.$item['TOTALCAMBIO'].'">
            //                 <span class="input-group-text">S/</span>
            //                 <input type="number" class="form-control" value="'.$item['TOTALCAMBIO'].'" disabled>
            //             </div>
            // 		</div>
            // 		<div class="col-xxl-4 col-md-12 col-12 mb-2">
            // 		    <label class="form-label">% Verisure</label>
            // 			<div class="input-group">
            // 			    <input type="hidden" name="totalVerisure['.$aleatorio.']" value="'.$item['VERISURE'].'">
            //                 <span class="input-group-text">S/</span>
            //                 <input type="number" class="form-control" value="'.$item['VERISURE'].'" disabled>
            //             </div>
            // 		</div>
            // 		<div class="col-xxl-4 col-md-12 col-12 mb-2">
            // 		    <label class="form-label">% Trabajador</label>
            // 			<div class="input-group">
            // 			    <input type="hidden" name="totalTrabajador['.$aleatorio.']" value="'.$item['TRABAJADOR'].'">
            //                 <span class="input-group-text">S/</span>
            //                 <input type="number" class="form-control" value="'.$item['TRABAJADOR'].'" disabled>
            //             </div>
            // 		</div>
            // 		<div class="col-xxl-10 col-md-10 col-10 ">
            // 		    <div class="form-floating">
            //                 <textarea class="form-control" id="detalle'.$aleatorio.'" name="obselemento['.$aleatorio.']" rows="3"></textarea>
            //                 <label for="detalle'.$aleatorio.'">Detalle</label>
            //             </div>
            // 		</div>
            // 		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
            // 			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico(\'itemreponer'.$aleatorio.'\');" data-tooltip="tooltip" aria-label="Eliminar Item a Reponer">
            //                 <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
            //             </button>
            // 		</div>
            // 	</div>';
            
                $html.='<div class="row col-xxl-12 col-md-12 col-12 m-0 mb-2 py-3 border-sistema-2px" id="itemreponer'.$aleatorio.'" style="border-radius: 10px;">
    	            <input type="hidden" name="itemReposicion[]" value="'.$item['IDITEM'].'">
    	            <input type="hidden" name="elemento['.$aleatorio.']" value="'.$item['ELEMENTO'].'">
    	            <input type="hidden" name="idelemento['.$aleatorio.']" value="'.$item['IDELEMENTO'].'">
    	            <input type="hidden" name="etiquetaitem['.$aleatorio.']" value="'.$item['ITEM'].'">
            		<div class="col-xxl-7 col-md-12 col-12 mb-3">
            			<div>
            				<label class="form-label">Elemento:</label>
            				<input type="text" class="form-control" value="'.$item['ITEM'].'" disabled>
            			</div>
            		</div>
            		<div class="col-xxl-5 col-md-12 col-12 mb-3">
            		    <label class="form-label">Valor Reposición</label>
            			<div class="input-group">
                            <span class="input-group-text">'.$item['SIMBOLO'].'</span>
                            <input type="number" class="form-control" step="0.01" min="0" value="'.$item['TOTAL'].'" disabled>
                        </div>
            		</div>
            		<div class="col-xxl-10 col-md-10 col-10 ">
            		    <div class="form-floating">
                            <textarea class="form-control" id="detalle'.$aleatorio.'" name="obselemento['.$aleatorio.']" rows="3"></textarea>
                            <label for="detalle'.$aleatorio.'">Detalle</label>
                        </div>
            		</div>
            		<div class="col-xxl-2 col-md-2 col-2 d-flex justify-content-end align-items-center">
            			<button type="button" class="btn bg-danger px-2 py-1" onclick="return eliminarBloqueDinamico(\'itemreponer'.$aleatorio.'\');" data-tooltip="tooltip" aria-label="Eliminar Item a Reponer">
                            <i class="mdi mdi-trash-can" style="font-size: 24px; color: #FFF"></i>
                        </button>
            		</div>
            	</div>';
    	    }
	    }
	    
	    echo $html;
    }

	public function solicitarReposicionItem()
	{
        $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $msjError = TRUE;
        $adjudicado = $this->request->getPost('txtAdjudicadoReposicion');
        $motivo = $this->request->getPost('txtMotivoReposicion');
        // $cuotas = $this->request->getPost('txtCuotasReposicion');
        $observacion = $this->request->getPost('txtObservacion');
        
        $itemDetalle = $this->request->getPost('itemReposicion');
        $etiquetaitem = $this->request->getPost('etiquetaitem');
        $elemento = $this->request->getPost('elemento');
        $idelemento = $this->request->getPost('idelemento');
        // $totalDescuento = $this->request->getPost('totalDescuento');
        // $totalVerisure = $this->request->getPost('totalVerisure');
        // $totalTrabajador = $this->request->getPost('totalTrabajador');
        $obsDetalle = $this->request->getPost('obselemento');
        // $tipoElemento = $this->request->getPost('tipoElementoReposicion');

        $adjunto = $this->request->getFile("fileAdjuntoReposicion");
        
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        $error = '';
        $error .= $this->complementos->validaCampo($adjudicado, 'required|trim', 'Usuario adjudicado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim|minlength[3]|maxlength[3]', 'Motivo');
        // $error .= $this->complementos->validaCampo($cuotas, 'required|trim|minlength[1]|maxlength[1]', 'Cuotas');
        
        if(empty($itemDetalle))
        {
            $error .= "<li>Debe registrar un item en la reposición.</li>";
        }

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        if($motivo == 'ROB' || $motivo == 'PER')
        {
            /*
            * ----------------------------
            * VALIDAR QUE EL ARCHIVO SE HAYA SUBIDO SIN ERRORES
            * ----------------------------
            */
            
            if (! $adjunto->isValid()) {
                $message = sprintf($this->mensajeError->msg201, $adjunto->getErrorString().'-'.$adjunto->getError());
                echo $this->alertas->alertaError($message);
                exit;
            }
            
            /*
            * ----------------------------
            * VALIDAR EXTENSIÓN DEL ARCHIVO SUBIDO
            * ----------------------------
            */
            
            $validationRule = [
                'fileAdjuntoReposicion' => [
                    'mime_in[fileAdjuntoReposicion,image/png,image/jpg,image/jpeg,image/gif,application/pdf]',
                    'ext_in[fileAdjuntoReposicion,pdf,jpeg]'
                ],
            ];

            if (! $this->validate($validationRule)) {
                $message = sprintf($this->mensajeError->msg201, implode(",", $this->validator->getErrors()));
                echo $this->alertas->alertaError($message);
                exit;
            }
        }
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        foreach($itemDetalle as $detalle)
        {
            $itemRepuesto = $this->reposicionesDetalle->where("IDDetalleAsignacion", $detalle)->findAll();

            if(!empty($itemRepuesto))
            {
                $msgExistencia .= "<li>El ".$etiquetaitem[$detalle]." ya fue repuesto.</li>";
            }
        }
		
        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * --------------------------------------------------------------------
        * ---------------- GESTIÓN DE SOLICITUD DE REPOSICIÓN ----------------
        * --------------------------------------------------------------------
        */
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS SOLICITUD
        * ----------------------------
        */

        $dataSolicitud = array();
        
        foreach($itemDetalle as $key => $detalle)
        {
            $elementosURES = array("KITDEMO");
            $elementosIT = array("LINEA", "MOVIL", "TARJETA", "HARDWARE");
            
            $area = in_array($elemento[$key], $elementosURES) ? "URES" : "IT";
            
            $dataSolicitud[] = array (
                'IDDetalleAsignacion'       => $detalle, 
                'Observacion'               => $obsDetalle[$key], 
                'AreaEncargada'             => $area, 
                'MotivoReposicion'          => $motivo,
                'IDUsuarioAdjudicado'       => $adjudicado, 
                'UsuarioCrea'               => $this->items['id'],
                'FechaCrea'                 => $fechaActual,    
                'Localhost'                 => $this->request->getIPAddress(),
                'Estado'                    => "CREA",
                'UsuarioEstado'             => $this->items['id'],
                'FechaEstado'               => $fechaActual,
                'IDDireccionEstado'         => $this->items['dpto'], 
                'IDAreaEstado'              => $this->items['idArea'], 
                'IDSubareaEstado'           => $this->items['idSubarea'], 
                'IDDelegacionEstado'        => $this->items['idDelegacionLog'],
                'IDPerfilEstado'            => $this->items['idPerfil'],
                'IDCargoEstado'             => $this->items['idCargoLog'],
                'MotivoEstado'              => $observacion
            );

        }
        
        $lastIdSolicitud = $this->solicitudReposicion->insertBatch($dataSolicitud);
        
        if($lastIdSolicitud === FALSE)
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la solicitud. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * --------------------------------------------------------------------
        * ------------------- GESTIÓN DE ACTA DE DEVOLUCIÓN ------------------
        * --------------------------------------------------------------------
        */
        
        /*
        * ----------------------------
        * INSERCIÓN DE DATOS DEVOLUCIÓN
        * ----------------------------
        */
        
        $datosUsuario = $this->usuarios->buscarUsuario($adjudicado);
        $tokenDevolucion = $this->complementos->generar_string_aleatorio(15);

        $dataDevolucion = array (
            'UsuarioDevolucion'         => $adjudicado, 
            'CargoDevolucion'           => $datosUsuario['Cargo'], 
            'DireccionDevolucion'       => $datosUsuario['IDDireccion'], 
            'AreaDevolucion'            => $datosUsuario['IDArea'], 
            'SubareaDevolucion'         => $datosUsuario['IDSubarea'], 
            'DelegacionDevolucion'      => $datosUsuario['IDDelegacion'], 
            'Motivo'                    => "REPOSICION", 
            'Observacion'               => "Devolución generada desde reposición.", 
            'TokenLinkFirma'            => $tokenDevolucion,
            'UsuarioCrea'               => $this->items['id'],
            'CargoCrea'                 => $this->items['cargo'], 
            'DireccionCrea'             => $this->items['dpto'],
            'AreaCrea'                  => $this->items['idArea'], 
            'SubareaCrea'               => $this->items['idSubarea'],
            'DelegacionCrea'            => $this->items['idDelegacionLog'],
            'FechaCrea'                 => $fechaActualAdd,
            'Localhost'                 => $this->request->getIPAddress()
        );

        $lastIdDevolucion = $this->devoluciones->insert($dataDevolucion, TRUE);
        
        if($lastIdDevolucion !== FALSE){
            $idDevolucion = $lastIdDevolucion;
        }
        else
        {
            $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar la reposición. Inténtelo luego.</li>");
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $dataDetalleDevolucion = array();

        foreach($itemDetalle as $key => $detalle)
        {
            $dataDetalleDevolucion[] = array (
                'IDDevolucion'          => $idDevolucion, 
                'IDDetalleAsignacion'   => $detalle,  
                'MotivoDevolucion'      => $motivo,
                'Observacion'           => $obsDetalle[$key],
                'UsuarioCrea'           => $this->items['id'],
                'FechaCrea'             => $fechaActualAdd,    
                'Localhost'             => $this->request->getIPAddress()
            );
        }
        $lastIdDetalleDevolucion = $this->devolucionesDetalle->insertBatch($dataDetalleDevolucion);
        
		if($lastIdDetalleDevolucion === FALSE){
            $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la reposición. Inténtelo luego.[INSERT]");
			echo $this->alertas->alertaError($message);
			exit;
		} 

        /*
        * ----------------------------
        * PREPARACIÓN DE CUERPO DE CORREO DE DEVOLUCIÓN
        * ----------------------------
        */

        $arrayCuerpo = array(
            "TITULO" => "ACTA DE DEVOLUCIÓN",
            "ACTA" => "ACTA DE DEVOLUCIÓN",
            "USUARIO" => ucwords(mb_strtolower($datosUsuario['Nombres'].' '.$datosUsuario['Apellidos'])),
            "URL_ACTA" => base_url()."/acta-devolucion/".$idDevolucion."/".$tokenDevolucion
        );

        $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
        
        /*
        * ----------------------------
        * PREPARACIÓN DE PARAMETROS PARA EL CORREO
        * ----------------------------
        */

        $asunto='ACTA DE DEVOLUCIÓN: '.$idDevolucion.' - '.$datosUsuario['Nombres'].' '.$datosUsuario['Apellidos'];
        //$correoDestino = array($asignado['Correo']);
        $configCorreo = array(
            "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
            "CORREO_ORIGEN" => $this->items['correoElectronico'],
            // "CORREOS_DESTINOS" => array($datosUsuario['Correo']),
            // "CORREOS_COPIA" => array("soporteit@verisure.pe"),
            // "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
            "CORREOS_DESTINOS" => array("josejesus.cuadros@verisure.pe"),
            "CORREOS_COPIA" => array(),
            "CORREOS_OCULTO" => array(),
            "ASUNTO" => $asunto,
            "MENSAJE" => $cuerpo
        );

        $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);

        $dataCorreo = array(
            "IDDevolucion"  => $idDevolucion,
            "Response"      => $estadoCorreo['RESPUESTA'],
            "Error"         => $estadoCorreo['ERROR'],
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress()
        );

        $this->correoStatusDevolucion->insert($dataCorreo, TRUE);
        
        /*
        * --------------------------------------------------------------------
        * ------------------- GESTIÓN DE ACTA DE REPOSICIÓN ------------------
        * --------------------------------------------------------------------
        */
        
        // if($motivo == 'FAL')
        // {
        //     foreach ($elemento as $key => $value) {      // Recorrer los elementos del array
        //         if ($value == "KITDEMO" || $value == "MOVIL") {                 // Si la clave es un entero:
        //             unset($itemDetalle[$key]);              // Destruir la variable (elemento del array)
        //         }
        //     }
        // }
        
        // if(!empty($itemDetalle))
        if($motivo != 'FAL' && $motivo != 'REN')
        {
            /*
            * ----------------------------
            * INSERCIÓN DE DATOS REPOSICIÓN
            * ----------------------------
            */
            
            $datosAdjudicado = $this->usuarios->buscarUsuario($adjudicado);
            $tokenReposicion = $this->complementos->generar_string_aleatorio(15);
    
            $dataReposicion = array (
                'UsuarioAdjudicado'         => $adjudicado, 
                'CargoAdjudicado'           => $datosAdjudicado['Cargo'], 
                'DireccionAdjudicado'       => $datosAdjudicado['IDDireccion'], 
                'AreaAdjudicado'            => $datosAdjudicado['IDArea'], 
                'SubareaAdjudicado'         => $datosAdjudicado['IDSubarea'], 
                'DelegacionAdjudicado'      => $datosAdjudicado['IDDelegacion'], 
                'TokenLinkFirma'            => $tokenReposicion, 
                'LiberadoFirma'             => "Y",
                'Motivo'                    => $motivo,
                'Observacion'               => $observacion,
                'Cuotas'                    => "Y",
                'UsuarioCrea'               => $this->items['id'],
                'CargoCrea'                 => $this->items['cargo'],
                'DireccionCrea'             => $this->items['dpto'],
                'AreaCrea'                  => $this->items['idArea'],
                'SubareaCrea'               => $this->items['idSubarea'],
                'DelegacionCrea'            => $this->items['idDelegacionLog'],
                'FechaCrea'                 => $fechaActual,    
                'Localhost'                 => $this->request->getIPAddress()
            );
    
            $lastIdReposicion = $this->reposiciones->insert($dataReposicion, TRUE);
            
            if($lastIdReposicion !== FALSE){
                $idReposicion = $lastIdReposicion;
            }
            else
            {
                $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar el acta de la reposición. Inténtelo luego.</li>");
                echo $this->alertas->alertaError($message);
                EXIT;
            }
    
            $dataDetalle = array();
            $totalSumaTrabajador = 0;
    
            foreach($itemDetalle as $key => $detalle)
            {
                if($elemento[$key]=="LINEA")
                {
                    $totalDescuento = 1;
                    $totalVerisure = 0;
                    $totalTrabajador = 1;
            
                    $cuotasTrabajador = 1;
                    $bolsa = "IT";
                }
                else if($elemento[$key]=="MOVIL")
                {
                    $movil = $this->moviles->obtenerMovil($idelemento[$key]);
                    
                    $contrato = $this->contratos->obtenerContratosXEquipo($idelemento[$key]);
                    $montoTotal = $this->complementos->calculoPenalidadMovil($contrato);
                    $cantidadRobo = $this->detalleasignaciones->obtenerDispositivosRobadosUsuario($adjudicado,"MOVIL");
                    $porcentajes = $this->complementos->calculoPorcentajeResponsabilidadMovil(count($cantidadRobo), $montoTotal, $motivo);
        
                    $totalDescuento = $montoTotal;
                    $totalVerisure = $porcentajes['VERISURE'];
                    $totalTrabajador = $porcentajes['TRABAJADOR'];
                    
                    $cuotasTrabajador = $this->complementos->rangoDescuentosMoviles($totalTrabajador) ;
                    $bolsa = "IT";
                }
                else if($elemento[$key]=="HARDWARE")
                {
                    $tipoCambio = $this->globales->tipoCambioVerisure();
                    
                    $informacionHardware = $this->hardware->obtenerHardware($idelemento[$key]);
                    $montoReposicion = $informacionHardware['PrecioCompra'];
                    $valorCambio = $tipoCambio[$informacionHardware['MonedaCompra']]['VALORCAMBIO'];
                    
                    //SI LA MONEDA ES OTRA QUE NO SEA PEN, DEBE REALIZARSE LA CONVERSIÓN Y AL RESULTADO SETEARLO COMO $montoTotal
                    
                    if($informacionHardware['MonedaCompra'] != 'PEN')
                    {
                        $montoTotal = number_format(round($montoReposicion * $valorCambio, 2), 2, '.', '');
                    }
                    else
                    {
                        $montoTotal = $montoReposicion;
                    }
                    
                    $cantidadRobo = $this->detalleasignaciones->obtenerDispositivosRobadosUsuario($adjudicado,"HARDWARE");
                    $porcentajes = $this->complementos->calculoPorcentajeResponsabilidadMovil(count($cantidadRobo), $montoTotal, $motivo);
                    
                    $totalDescuento = $montoTotal;
                    $totalVerisure = $porcentajes['VERISURE'];
                    $totalTrabajador = $porcentajes['TRABAJADOR'];
                    
                    $cuotasTrabajador = $this->complementos->rangoDescuentosHardware($totalTrabajador) ;
                    $bolsa = "IT";
                }
                else if($elemento[$key]=="TARJETA")
                {
                    $informacionTarjeta = $this->tarjetasAcceso->where("IDTarjetaAcceso", $idelemento[$key])->first();
        
                    $totalDescuento = $informacionTarjeta['PrecioCompra'];
                    $totalVerisure = 0;
                    $totalTrabajador = $informacionTarjeta['PrecioCompra'];
                    
                    $cuotasTrabajador = 1;
                    $bolsa = "IT";
                }
                else if($elemento[$key]=="KITDEMO")
                {
                    $tipoCambio = $this->globales->tipoCambioVerisure();
            
                    $informacionKit = $this->kitsDemo->obtenerItemKitDemo($idelemento[$key]);
                    $montoReposicion = $informacionKit['PrecioReposicion'];
                    $valorCambio = $tipoCambio[$informacionKit['MonedaReposicion']]['VALORCAMBIO'];
                    
                    //SI LA MONEDA ES OTRA QUE NO SEA PEN, DEBE REALIZARSE LA CONVERSIÓN Y AL RESULTADO SETEARLO COMO $montoTotal
                    
                    if($informacionKit['MonedaReposicion'] != 'PEN')
                    {
                        $montoTotal = number_format(round($montoReposicion * $valorCambio, 2), 2, '.', '');
                    }
                    else
                    {
                        $montoTotal = $montoReposicion;
                    }
                    
                    $cantidadRobo = $this->detalleasignaciones->obtenerDispositivosRobadosUsuario($adjudicado,"KITDEMO",$idelemento[$key]);
                    $porcentajes = $this->complementos->calculoPorcentajeResponsabilidadKitDemo(count($cantidadRobo), $montoTotal, $motivo);
                    
                    $totalDescuento = $montoTotal;
                    $totalVerisure = $porcentajes['VERISURE'];
                    $totalTrabajador = $porcentajes['TRABAJADOR'];
                    
                    $cuotasTrabajador = $this->complementos->rangoDescuentosKitDemo($totalTrabajador);
                    $bolsa = "URES";
                }
                else
                {
                    $totalDescuento = 0;
                    $totalVerisure = 0;
                    $totalTrabajador = 0;
                    
                    $cuotasTrabajador = 1;
                    $bolsa = "IT";
                }
                
                $dataDetalle = array (
                    'IDReposicion'          => $idReposicion, 
                    'IDDetalleAsignacion'   => $detalle,  
                    'TotalDescuento'        => $totalDescuento, 
                    'TotalVerisure'         => $totalVerisure, 
                    'TotalTrabajador'       => $totalTrabajador, 
                    'Observacion'           => $obsDetalle[$key], 
                    'TotalCuotas'           => $cuotasTrabajador,
                    'Bolsa'                 => $bolsa,
                    'Cobrado'               => 'N',
                    'UsuarioCrea'           => $this->items['id'],
                    'FechaCrea'             => $fechaActual,    
                    'Localhost'             => $this->request->getIPAddress()
                );
    
                $lastIdDetalleReposicion = $this->reposicionesDetalle->insert($dataDetalle, TRUE);
                
                if($lastIdDetalleReposicion === FALSE){
                    $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la reposición de un item. Inténtelo luego.[ARD]");
                    echo $this->alertas->alertaError($message);
                    exit;
                } 
                
                /*
                * ----------------------------
                * INSERCIÓN DE DATOS REPOSICIÓN - CRONOGRAMA DE PAGOS
                * ----------------------------
                */
                
                $diaPlanilla = $this->globales->diaCortePlanilla();
        
                $fechaPlanillaActual = date("Y-m-".$diaPlanilla);
                
                $timePlanilla = strtotime($fechaPlanillaActual);
                $timeActual = strtotime($fechaActual);
        
                $mesInicioCuotas=0;
                $anioInicioCuotas=0;
        
                if($timePlanilla > $timeActual)
                {
                    $mesInicioCuotas = date("m");
                    $anioInicioCuotas = date("Y");
                }
                else
                {
                    $mesActual = date("m");
                    $anioActual = date("Y");
        
                    if($mesActual == 12)
                    {
                        $mesInicioCuotas = 1;
                        $anioInicioCuotas = $anioActual +1 ;
                    }
                    else
                    {
                        $mesInicioCuotas = $mesActual + 1;
                        $anioInicioCuotas = $anioActual;
                    }
                }
                    
                $dataCronogramaPago = array();
                
                $descuentoMensual = number_format(round($totalTrabajador / $cuotasTrabajador, 2), 2, '.', '');
        
                for($i=1; $i<=$cuotasTrabajador;$i++)
                {
                    if($i == ($cuotasTrabajador))
                    {
                        $montoCuota = ($totalTrabajador - (($cuotasTrabajador - 1)*$descuentoMensual));
                    }
                    else
                    {
                        $montoCuota = $descuentoMensual;
                    }
        
                    $dataCronogramaPago[] = array (
                        'IDDetalleReposicion'   => $lastIdDetalleReposicion, 
                        'NroCuota'              => $i, 
                        'MesCuota'              => $mesInicioCuotas, 
                        'AnioCuota'             => $anioInicioCuotas, 
                        'MontoCuota'            => $montoCuota, 
                        'Observacion'           => 'Cuota generada automáticamente', 
                        'UsuarioCrea'           => $this->items['id'],
                        'FechaCrea'             => $fechaActual,    
                        'Localhost'             => $this->request->getIPAddress()
                    );
        
                    $mesInicioCuotas++;
        
                    if($mesInicioCuotas > 12)
                    {
                        $mesInicioCuotas = 1;
                        $anioInicioCuotas = $anioInicioCuotas + 1;
                    }
                }
        
                $lastIdCronograma = $this->reposicionesCronogramaPago->insertBatch($dataCronogramaPago);
                
        		if($lastIdCronograma === FALSE){
                    $this->reposicionesDetalle->where('IDDetalleReposicion', $lastIdDetalleReposicion)->delete();
                    $message = sprintf($this->mensajeError->msg201, "No se pudo registrar un detalle de la reposición. Inténtelo luego.[INSERT]");
        			echo $this->alertas->alertaError($message);
        			exit;
        		} 
        
                /*
                * ----------------------------
                * ACTUALIZAR ESTADO DEL ITEM DE LA SOLICITUD DE REPOSICIÓN
                * ----------------------------
                */
                
                $updSolicitud = array(
                    "GeneraReposicion"      => "Y",
                    "DescargoEvaluacion"    => "Acta de reposición generada por politíca asociada.",
                    "Estado"                => 'COMP',
                    "UsuarioEstado"         => $this->items['id'],
                    "FechaEstado"           => $fechaActualAdd,
                    'IDDireccionEstado'     => $this->items['dpto'], 
                    'IDAreaEstado'          => $this->items['idArea'], 
                    'IDSubareaEstado'       => $this->items['idSubarea'], 
                    'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
                    'IDPerfilEstado'        => $this->items['idPerfil'],
                    'IDCargoEstado'         => $this->items['idCargoLog'],
                    "MotivoEstado"          => "Acta de reposición generada."
                );
                
                $lastIdUpdate = $this->solicitudReposicion->where("IDDetalleAsignacion", $detalle)->set($updSolicitud)->update();
                
            }
            
            /*
            * ----------------------------
            * GUARDAR ARCHIVO ADJUNTO
            * ----------------------------
            */
            
            if($motivo == 'ROB' || $motivo == 'PER')
            {
                if($adjunto->guessExtension() != null)
                {
                    $extensionDoc = $adjunto->guessExtension();
                }
                else
                {
                    $nombre_original = $adjunto->getBasename();
                    $fileNameCmps = explode(".", $nombre_original);
                    $extensionDoc = strtolower(end($fileNameCmps));
                }
                
                /*
                * ----------------------------
                * INSERCIÓN DE DATOS ADJUNTOS
                * ----------------------------
                */
    
                $dataAdjuntoReposicion = array (
                    'IDReposicion'      => $idReposicion, 
                    'Nombre'            => "Denuncia Reposición", 
                    'Extension'         => $extensionDoc,
                    'Observacion'       => "Reporte de denuncia de equipos.",
                    'ReemplazoFirma'    => "N",  
                    'UsuarioCrea'       => $this->items['id'],
                    'FechaCrea'         => $fechaActual,    
                    'Localhost'         => $this->request->getIPAddress()
                );
    
                $lastIdAdjuntosReposiciones = $this->reposicionesAdjuntos->insert($dataAdjuntoReposicion, TRUE);
    
                if($lastIdAdjuntosReposiciones === FALSE){
                    // $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                    // $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                    // $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                    /*$this->devolucionesDetalle->where('IDDevolucion', $idDevolucion)->delete();
                    $this->devoluciones->where('IDDevolucion', $idDevolucion)->delete();*/
                    $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[INSERT]");
                    echo $this->alertas->alertaError($message);
                    exit;
                }
    
                /*
                * ----------------------------
                * GUARDAR ARCHIVO ADJUNTO REPOSICIÓN
                * ----------------------------
                */
                $ruta = "public/docs/ActaReposicion/";
                $nombreArchivo = $idReposicion."-".$lastIdAdjuntosReposiciones;
    
                if(!file_exists($ruta))
                {
                    @mkdir($ruta, 0777, true);
                }
    
                # si exsite la carpeta o se ha creado
                if (file_exists($ruta) || @mkdir($ruta)) 
                {
                    $nuevonombre = $nombreArchivo.'.'.$extensionDoc;
                    
                    $estadoMove = $adjunto->move($ruta, $nuevonombre);
                    
                    if (!$estadoMove) {
                        // $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                        // $this->reposicionesAdjuntos->where('IDAdjuntoReposicion', $lastIdAdjuntosReposiciones)->delete();
                        // $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                        // $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                        $message = sprintf($this->mensajeError->msg201, "No se pudo registrar el archivo adjunto. Inténtelo luego.[SAVEDOC]");
                        echo $this->alertas->alertaError($message);
                        exit;
                    }
                }
                else
                {
                    // $this->reposicionesCronogramaPago->where('IDReposicion', $idReposicion)->delete();
                    // $this->reposicionesAdjuntos->where('IDAdjuntoReposicion', $lastIdAdjuntosReposiciones)->delete();
                    // $this->reposicionesDetalle->where('IDReposicion', $idReposicion)->delete();
                    // $this->reposiciones->where('IDReposicion', $idReposicion)->delete();
                    $message = sprintf($this->mensajeError->msg201, "No existe ruta. Inténtelo luego.[SAVEDOC]");
                    echo $this->alertas->alertaError($message);
                    exit;
                }
                
            }
            
            /*
            * ----------------------------
            * PREPARACIÓN DE CUERPO DE CORREO DE REPOSICIÓN
            * ----------------------------
            */
    
            $arrayCuerpo = array(
                "TITULO" => "ACTA DE REPOSICIÓN",
                "ACTA" => "ACTA DE REPOSICIÓN",
                "USUARIO" => ucwords(mb_strtolower($datosAdjudicado['Nombres'].' '.$datosAdjudicado['Apellidos'])),
                "URL_ACTA" => base_url()."/acta-reposicion/".$idReposicion."/".$tokenReposicion
            );
    
            $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
            
            /*
            * ----------------------------
            * PREPARACIÓN DE PARAMETROS PARA EL CORREO
            * ----------------------------
            */
    
            $asunto='ACTA DE REPOSICIÓN: '.$idReposicion.' - '.$datosAdjudicado['Nombres'].' '.$datosAdjudicado['Apellidos'];
            //$correoDestino = array($asignado['Correo']);
            $configCorreo = array(
                "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                "CORREO_ORIGEN" => $this->items['correoElectronico'],
                // "CORREOS_DESTINOS" => array($datosAdjudicado['Correo']),
                // "CORREOS_COPIA" => array("soporteit@verisure.pe"),
                // "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
                "CORREOS_DESTINOS" => array("josejesus.cuadros@verisure.pe"),
                "CORREOS_COPIA" => array(),
                "CORREOS_OCULTO" => array(),
                "ASUNTO" => $asunto,
                "MENSAJE" => $cuerpo
            );
    
            $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
    
            $dataCorreo = array(
                "IDReposicion"  => $idReposicion,
                "Response"      => $estadoCorreo['RESPUESTA'],
                "Error"         => $estadoCorreo['ERROR'],
                'UsuarioCrea'   => $this->items['id'],
                'FechaCrea'     => $fechaActual,    
                'Localhost'     => $this->request->getIPAddress()
            );
    
            $this->correoStatusReposicion->insert($dataCorreo, TRUE);
            
        }
        
        $message = sprintf($this->mensajeError->msg201, "La reposición fue solicitada exitosamente.");
        echo $this->alertas->alertaExito($message);
        echo $this->alertas->refrescar(1);
        // echo $this->alertas->reDireccion(base_url()."/solicitud-reposicion-items/".$lastIdSolicitud, 1);
        
	}
	
	public function informacionSolicitudReposicion($idSolicitudReposicion)
	{
	    if(isset($this->items['id'])){

			/* ACCIONES */
			
		    $solicitud = $this->solicitudReposicion->obtenerSolicitudReposicion($idSolicitudReposicion);
			$motivosDevolucion = $this->globales->motivosDevolucion();
			$estadosSolicitud = $this->globales->estadosSolicitud();
			
            $autorizado = in_array($this->items['idPerfil'], $this->globales->perfilesAutorizadosArea()[$solicitud['AreaEncargada']]);
            
		    $adjudicado = $this->usuarios->where("IdUsuario ", $solicitud['IDUsuarioAdjudicado'])->first();
		    $solicitante = $this->usuarios->where("IdUsuario ", $solicitud['UsuarioCrea'])->first();

            $solicitud['NombreAdjudicado'] = strtoupper($adjudicado['Nombres'].' '.$adjudicado['Apellidos']);
            $solicitud['MatriculaAdjudicado'] = $adjudicado['Matricula'];
            $solicitud['NombreSolicitante'] = strtoupper($solicitante['Nombres'].' '.$solicitante['Apellidos']);
            $solicitud['MatriculaSolicitante'] = $solicitante['Matricula'];
            
            $elemento = $this->devolverInformacionElemento($solicitud['TipoElemento'], $solicitud['IDElemento']);
            $solicitud['Elemento'] = $elemento['TIPO'].' | '.$elemento['Marca'].' - '.$elemento['Modelo'].' - '.$elemento['Serie'];
            
            $timeline = $this->auditoria->listarAuditoriaEstadosSolicitudReposicion($idSolicitudReposicion);
            
            foreach($timeline as $key=>$value)
            {
                $modifica = $this->usuarios->where("IdUsuario ", $value['IDUsuario'])->first();
                $timeline[$key]['NombreUsuarioModifica'] = $modifica['Nombres'].' '.$modifica['Apellidos'];
                $timeline[$key]['MatriculaUsuarioModifica'] = $modifica['Matricula'];
                
                $direccion = $this->estructuraDirecciones->where("IDDireccion", $value['IDDireccion'])->first();
                $area = $this->estructuraAreas->where("IDArea", $value['IDArea'])->first();
                $subarea = $this->estructuraSubareas->where("IDSubarea", $value['IDSubarea'])->first();
                $delegacion = $this->estructuraDelegaciones->where("IDDelegacion", $value['IDDelegacion'])->first();
                $cargo = $this->cargos->where("IDCargo", $value['IDCargo'])->first();
                
                $timeline[$key]['DireccionModifica'] = $direccion['Direccion'];
                $timeline[$key]['AreaModifica'] = $area['Area'];
                $timeline[$key]['SubareaModifica'] = $subarea['Subarea'];
                $timeline[$key]['DelegacionModifica'] = $delegacion['CC'].' - '.$delegacion['LN'].' | '.$delegacion['Delegacion'];
                $timeline[$key]['CargoModifica'] = $cargo['Cargo'];
                
            }
            
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Solicitudes de Reposición | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Información de Solicitud | '.$solicitud['IDSolicitudReposicion'],
                'previo'                => 'solicitudes-reposicion',
				'solicitud'             => $solicitud,
				'motivosDevolucion'     => $motivosDevolucion,
				'estadosSolicitud'      => $estadosSolicitud,
				'autorizado'            => $autorizado,
				'timeline'              => $timeline
			);
			$data = array_merge($data, $this->items);
			return view('solicitudes/solicitudes_reposicion_informacion',$data);			
		} else {
			return view('errors/500');
		}
	}
	
	public function modificarEstadoSolicitudReposicion($idSolicitudReposicion)
	{
	    $fechaActual = date("Y-m-d H:i:s");
        $fechaActualAdd = date("Y-m-d H:i:s", strtotime($fechaActual)+1);
        
	   // $nuevaNotificacion = array (
    //         'tabla'             => 'peticiones', 
    //         'idreferencia'      => $idPeticion,
    //         'url'               => "detalle-peticion/".$idPeticion, 
    //         'usuarioregistra'   => $this->items['id'],
    //         'fecharegistra'     => $fechaActual
    //     );
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError       = TRUE;
        $estado         = $this->request->getPost('txtEstadoSolicitudReposicion_i');
        $motivo         = $this->request->getPost('txtDescargoEvaluacion_i');
        $cobro          = $this->request->getPost('chkGeneraReposicion_i');
        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idSolicitudReposicion, 'required|trim|numeric', 'ID Solicitud Reposición');
        // $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[4]|maxlength[4]', 'Estado');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        $dataSolicitud = array (
            'UsuarioModifica'       => $this->items['id'],
            'Estado'                => $estado, 
            'UsuarioEstado'         => $this->items['id'],
            'IDDireccionEstado'     => $this->items['dpto'], 
            'IDSubareaEstado'       => $this->items['idSubarea'], 
            'IDAreaEstado'          => $this->items['idArea'], 
            'IDPerfilEstado'        => $this->items['idPerfil'],
            'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
            'IDCargoEstado'         => $this->items['idCargoLog'],
            'Localhost'             => $this->request->getIPAddress()
        );
        
        $infoSolicitud = $this->solicitudReposicion->obtenerSolicitudReposicion($idSolicitudReposicion);
        
        if($estado == 'RECI')
        {
            if($infoSolicitud['Estado'] != 'CREA')
            {
                $message = sprintf($this->mensajeError->msg201, "No se puede gestionar el cambio de estado. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
            else
            {
                $dataSolicitud['FechaModifica']  = $fechaActual;
                $dataSolicitud['FechaEstado']    = $fechaActual;
                $dataSolicitud['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Se recibió el elemento.";
                
                // $nuevaNotificacion['usuariodestino'] = $infoSolicitud['UsuarioCrea'];
                // $nuevaNotificacion['gtdestino'] = null;
                // $nuevaNotificacion['perfildestino'] = null;
                // $nuevaNotificacion['mensaje'] = "Se ha <span class='color-asig'>ASIGNADO</span> la petición #".$idPeticion.".";
            }
        }
        else if($estado == 'INIC')
        {
            if($infoSolicitud['Estado'] == 'COMP')
            {
                $message = sprintf($this->mensajeError->msg201, "No se puede gestionar el cambio de estado. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
            else if($infoSolicitud['Estado'] == 'CREA')
            {
                $dataSolicitudPrev = array (
                    'UsuarioModifica'       => $this->items['id'],
                    'FechaModifica'         => $fechaActual,
                    'Estado'                => 'RECI', 
                    'FechaEstado'           => $fechaActual,
                    'UsuarioEstado'         => $this->items['id'],
                    'IDSubareaEstado'       => $this->items['idSubarea'], 
                    'IDAreaEstado'          => $this->items['idArea'], 
                    'IDDireccionEstado'     => $this->items['dpto'], 
                    'IDPerfilEstado'        => $this->items['idPerfil'],
                    'IDDelegacionEstado'    => $this->items['idDelegacionLog'],
                    'IDCargoEstado'         => $this->items['idCargoLog'],
                    'MotivoEstado'          => "Se recibió el elemento.",
                    'Localhost'             => $this->request->getIPAddress()
                );
                $lastIdPrev = $this->solicitudReposicion->update([$idSolicitudReposicion], $dataSolicitudPrev);
                
                if($lastIdPrev !== FALSE){
        			$dataSolicitud['FechaModifica']  = $fechaActualAdd;
                    $dataSolicitud['FechaEstado']    = $fechaActualAdd;
                    $dataSolicitud['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Evaluación de elemento iniciado.";
                    
                    // $nuevaNotificacion['usuariodestino'] = $infoSolicitud['UsuarioCrea'];
                    // $nuevaNotificacion['gtdestino'] = null;
                    // $nuevaNotificacion['perfildestino'] = null;
                    // $nuevaNotificacion['mensaje'] = "Se ha <span class='color-asig'>INICIADO LA GESTIÓN</span> de la petición #".$idPeticion.".";
        		}
        		else
        		{
        		    $message = sprintf($this->mensajeError->msg201, "No se puede gestionar la recepción del elemento. Inténtelo luego.[".$estado."]");
                    echo $this->alertas->alertaError($message);
        			exit;
        		}
            }
            else
            {
                $dataSolicitud['FechaModifica']  = $fechaActual;
                $dataSolicitud['FechaEstado']    = $fechaActual;
                $dataSolicitud['MotivoEstado']   = $motivo != '' && $motivo != null ? $motivo : "Evaluación de elemento iniciado.";
                
                // $nuevaNotificacion['usuariodestino'] = $infoSolicitud['UsuarioCrea'];
                // $nuevaNotificacion['gtdestino'] = null;
                // $nuevaNotificacion['perfildestino'] = null;
                // $nuevaNotificacion['mensaje'] = "Se ha <span class='color-asig'>INICIADO LA GESTIÓN</span> de la petición #".$idPeticion.".";
            }
            
        }
        else if($estado == 'COMP')
        {
            if($infoSolicitud['Estado'] == 'INIC')
            {
                $dataSolicitud['FechaModifica']         = $fechaActual;
                $dataSolicitud['FechaEstado']           = $fechaActual;
                $dataSolicitud['MotivoEstado']          = $motivo != '' && $motivo != null ? $motivo : "Evaluación concluida.";
                $dataSolicitud['GeneraReposicion']      = $cobro != '' ? "Y" : "N";
                $dataSolicitud['DescargoEvaluacion']    = $motivo;
                
                if($cobro != '')
                {
                    /*
                    * ----------------------------
                    * INSERCIÓN DE DATOS REPOSICIÓN
                    * ----------------------------
                    */
                    
                    $datosAdjudicado = $this->usuarios->buscarUsuario($infoSolicitud['IDUsuarioAdjudicado']);
                    $tokenReposicion = $this->complementos->generar_string_aleatorio(15);
            
                    $dataReposicion = array (
                        'UsuarioAdjudicado'         => $infoSolicitud['IDUsuarioAdjudicado'], 
                        'CargoAdjudicado'           => $datosAdjudicado['Cargo'], 
                        'DireccionAdjudicado'       => $datosAdjudicado['IDDireccion'], 
                        'AreaAdjudicado'            => $datosAdjudicado['IDArea'], 
                        'SubareaAdjudicado'         => $datosAdjudicado['IDSubarea'], 
                        'DelegacionAdjudicado'      => $datosAdjudicado['IDDelegacion'], 
                        'TokenLinkFirma'            => $tokenReposicion, 
                        'LiberadoFirma'             => "Y",
                        'Motivo'                    => $infoSolicitud['MotivoReposicion'],
                        'Observacion'               => $motivo,
                        'Cuotas'                    => "Y",
                        'UsuarioCrea'               => $this->items['id'],
                        'CargoCrea'                 => $this->items['cargo'],
                        'DireccionCrea'             => $this->items['dpto'],
                        'AreaCrea'                  => $this->items['idArea'],
                        'SubareaCrea'               => $this->items['idSubarea'],
                        'DelegacionCrea'            => $this->items['idDelegacionLog'],
                        'FechaCrea'                 => $fechaActual,    
                        'Localhost'                 => $this->request->getIPAddress()
                    );
            
                    $lastIdReposicion = $this->reposiciones->insert($dataReposicion, TRUE);
                    
                    if($lastIdReposicion !== FALSE){
                        $idReposicion = $lastIdReposicion;
                    }
                    else
                    {
                        $message = sprintf($this->mensajeError->msg201, "<li>Hubo un problema al registrar el acta de la reposición. Inténtelo luego.</li>");
                        echo $this->alertas->alertaError($message);
                        EXIT;
                    }
            
                    $dataDetalle = array();
                    $totalSumaTrabajador = 0;
            
                    if($infoSolicitud['TipoElemento']=="LINEA")
                    {
                        $totalDescuento = 1;
                        $totalVerisure = 0;
                        $totalTrabajador = 1;
                
                        $cuotasTrabajador = 1;
                        $bolsa = "IT";
                    }
                    else if($infoSolicitud['TipoElemento']=="MOVIL")
                    {
                        $contrato = $this->contratos->obtenerContratosXEquipo($infoSolicitud['IDElemento']);
                        $montoTotal = $this->complementos->calculoPenalidadMovil($contrato);
                        $cantidadRobo = $this->detalleasignaciones->obtenerDispositivosRobadosUsuario($infoSolicitud['IDUsuarioAdjudicado'],"MOVIL");
                        $porcentajes = $this->complementos->calculoPorcentajeResponsabilidadMovil(count($cantidadRobo), $montoTotal, $infoSolicitud['MotivoReposicion']);
            
                        $totalDescuento = $montoTotal;
                        $totalVerisure = $porcentajes['VERISURE'];
                        $totalTrabajador = $porcentajes['TRABAJADOR'];
                        
                        $cuotasTrabajador = $this->complementos->rangoDescuentosMoviles($totalTrabajador) ;
                        $bolsa = "IT";
                    }
                    else if($infoSolicitud['TipoElemento']=="HARDWARE")
                    {
                        $tipoCambio = $this->globales->tipoCambioVerisure();
                        
                        $informacionHardware = $this->hardware->obtenerHardware($infoSolicitud['IDElemento']);
                        $montoReposicion = $informacionHardware['PrecioCompra'];
                        $valorCambio = $tipoCambio[$informacionHardware['MonedaCompra']]['VALORCAMBIO'];
                        
                        //SI LA MONEDA ES OTRA QUE NO SEA PEN, DEBE REALIZARSE LA CONVERSIÓN Y AL RESULTADO SETEARLO COMO $montoTotal
                        
                        if($informacionHardware['MonedaCompra'] != 'PEN')
                        {
                            $montoTotal = number_format(round($montoReposicion * $valorCambio, 2), 2, '.', '');
                        }
                        else
                        {
                            $montoTotal = $montoReposicion;
                        }
                        
                        $cantidadRobo = $this->detalleasignaciones->obtenerDispositivosRobadosUsuario($infoSolicitud['IDUsuarioAdjudicado'],"HARDWARE");
                        $porcentajes = $this->complementos->calculoPorcentajeResponsabilidadMovil(count($cantidadRobo), $montoTotal, $infoSolicitud['MotivoReposicion']);
                        
                        $totalDescuento = $montoTotal;
                        $totalVerisure = $porcentajes['VERISURE'];
                        $totalTrabajador = $porcentajes['TRABAJADOR'];
                        
                        $cuotasTrabajador = $this->complementos->rangoDescuentosHardware($totalTrabajador) ;
                        $bolsa = "IT";
                    }
                    else if($infoSolicitud['TipoElemento']=="TARJETA")
                    {
                        $informacionTarjeta = $this->tarjetasAcceso->where("IDTarjetaAcceso", $infoSolicitud['IDElemento'])->first();
            
                        $totalDescuento = $informacionTarjeta['PrecioCompra'];
                        $totalVerisure = 0;
                        $totalTrabajador = $informacionTarjeta['PrecioCompra'];
                        
                        $cuotasTrabajador = 1;
                        $bolsa = "IT";
                    }
                    else if($infoSolicitud['TipoElemento']=="KITDEMO")
                    {
                        $tipoCambio = $this->globales->tipoCambioVerisure();
                
                        $informacionKit = $this->kitsDemo->obtenerItemKitDemo($infoSolicitud['IDElemento']);
                        $montoReposicion = $informacionKit['PrecioReposicion'];
                        $valorCambio = $tipoCambio[$informacionKit['MonedaReposicion']]['VALORCAMBIO'];
                        
                        //SI LA MONEDA ES OTRA QUE NO SEA PEN, DEBE REALIZARSE LA CONVERSIÓN Y AL RESULTADO SETEARLO COMO $montoTotal
                        
                        if($informacionKit['MonedaReposicion'] != 'PEN')
                        {
                            $montoTotal = number_format(round($montoReposicion * $valorCambio, 2), 2, '.', '');
                        }
                        else
                        {
                            $montoTotal = $montoReposicion;
                        }
                        
                        $cantidadRobo = $this->detalleasignaciones->obtenerDispositivosRobadosUsuario($infoSolicitud['IDUsuarioAdjudicado'],"KITDEMO",$infoSolicitud['IDElemento']);
                        $porcentajes = $this->complementos->calculoPorcentajeResponsabilidadKitDemo(count($cantidadRobo), $montoTotal, $infoSolicitud['MotivoReposicion']);
                        
                        $totalDescuento = $montoTotal;
                        $totalVerisure = $porcentajes['VERISURE'];
                        $totalTrabajador = $porcentajes['TRABAJADOR'];
                        
                        $cuotasTrabajador = $this->complementos->rangoDescuentosKitDemo($totalTrabajador);
                        $bolsa = "URES";
                    }
                    else
                    {
                        $totalDescuento = 0;
                        $totalVerisure = 0;
                        $totalTrabajador = 0;
                        
                        $cuotasTrabajador = 1;
                        $bolsa = "IT";
                    }
                    
                    $dataDetalle = array (
                        'IDReposicion'          => $idReposicion, 
                        'IDDetalleAsignacion'   => $infoSolicitud['IDDetalleAsignacion'],  
                        'TotalDescuento'        => $totalDescuento, 
                        'TotalVerisure'         => $totalVerisure, 
                        'TotalTrabajador'       => $totalTrabajador, 
                        'Observacion'           => $motivo, 
                        'TotalCuotas'           => $cuotasTrabajador,
                        'Bolsa'                 => $bolsa,
                        'Cobrado'               => 'N',
                        'UsuarioCrea'           => $this->items['id'],
                        'FechaCrea'             => $fechaActual,    
                        'Localhost'             => $this->request->getIPAddress()
                    );
        
                    $lastIdDetalleReposicion = $this->reposicionesDetalle->insert($dataDetalle, TRUE);
                    
                    if($lastIdDetalleReposicion === FALSE){
                        $message = sprintf($this->mensajeError->msg201, "No se pudo registrar la reposición de un item. Inténtelo luego.[ARD]");
                        echo $this->alertas->alertaError($message);
                        exit;
                    } 
                    
                    /*
                    * ----------------------------
                    * INSERCIÓN DE DATOS REPOSICIÓN - CRONOGRAMA DE PAGOS
                    * ----------------------------
                    */
                    
                    $diaPlanilla = $this->globales->diaCortePlanilla();
            
                    $fechaPlanillaActual = date("Y-m-".$diaPlanilla);
                    
                    $timePlanilla = strtotime($fechaPlanillaActual);
                    $timeActual = strtotime($fechaActual);
            
                    $mesInicioCuotas=0;
                    $anioInicioCuotas=0;
            
                    if($timePlanilla > $timeActual)
                    {
                        $mesInicioCuotas = date("m");
                        $anioInicioCuotas = date("Y");
                    }
                    else
                    {
                        $mesActual = date("m");
                        $anioActual = date("Y");
            
                        if($mesActual == 12)
                        {
                            $mesInicioCuotas = 1;
                            $anioInicioCuotas = $anioActual +1 ;
                        }
                        else
                        {
                            $mesInicioCuotas = $mesActual + 1;
                            $anioInicioCuotas = $anioActual;
                        }
                    }
                        
                    $dataCronogramaPago = array();
                    
                    $descuentoMensual = number_format(round($totalTrabajador / $cuotasTrabajador, 2), 2, '.', '');
            
                    for($i=1; $i<=$cuotasTrabajador;$i++)
                    {
                        if($i == ($cuotasTrabajador))
                        {
                            $montoCuota = ($totalTrabajador - (($cuotasTrabajador - 1)*$descuentoMensual));
                        }
                        else
                        {
                            $montoCuota = $descuentoMensual;
                        }
            
                        $dataCronogramaPago[] = array (
                            'IDDetalleReposicion'   => $lastIdDetalleReposicion, 
                            'NroCuota'              => $i, 
                            'MesCuota'              => $mesInicioCuotas, 
                            'AnioCuota'             => $anioInicioCuotas, 
                            'MontoCuota'            => $montoCuota, 
                            'Observacion'           => 'Cuota generada automáticamente', 
                            'UsuarioCrea'           => $this->items['id'],
                            'FechaCrea'             => $fechaActual,    
                            'Localhost'             => $this->request->getIPAddress()
                        );
            
                        $mesInicioCuotas++;
            
                        if($mesInicioCuotas > 12)
                        {
                            $mesInicioCuotas = 1;
                            $anioInicioCuotas = $anioInicioCuotas + 1;
                        }
                    }
            
                    $lastIdCronograma = $this->reposicionesCronogramaPago->insertBatch($dataCronogramaPago);
                    
            		if($lastIdCronograma === FALSE){
                        $this->reposicionesDetalle->where('IDDetalleReposicion', $lastIdDetalleReposicion)->delete();
                        $message = sprintf($this->mensajeError->msg201, "No se pudo registrar un detalle de la reposición. Inténtelo luego.[INSERT]");
            			echo $this->alertas->alertaError($message);
            			exit;
            		} 
            
                    /*
                    * ----------------------------
                    * PREPARACIÓN DE CUERPO DE CORREO DE REPOSICIÓN
                    * ----------------------------
                    */
            
                    $arrayCuerpo = array(
                        "TITULO" => "ACTA DE REPOSICIÓN",
                        "ACTA" => "ACTA DE REPOSICIÓN",
                        "USUARIO" => ucwords(mb_strtolower($datosAdjudicado['Nombres'].' '.$datosAdjudicado['Apellidos'])),
                        "URL_ACTA" => base_url()."/acta-reposicion/".$idReposicion."/".$tokenReposicion
                    );
            
                    $cuerpo = $this->plantillasCorreo->cuerpoVeriactivosActas($arrayCuerpo);
                    
                    /*
                    * ----------------------------
                    * PREPARACIÓN DE PARAMETROS PARA EL CORREO
                    * ----------------------------
                    */
            
                    $asunto='ACTA DE REPOSICIÓN: '.$idReposicion.' - '.$datosAdjudicado['Nombres'].' '.$datosAdjudicado['Apellidos'];
                    //$correoDestino = array($asignado['Correo']);
                    $configCorreo = array(
                        "NOMBRE_ORIGEN" => $this->items['nombres'].' '.$this->items['apellidos'],
                        "CORREO_ORIGEN" => $this->items['correoElectronico'],
                        // "CORREOS_DESTINOS" => array($datosAdjudicado['Correo']),
                        // "CORREOS_COPIA" => array("soporteit@verisure.pe"),
                        // "CORREOS_OCULTO" => array("josejesus.cuadros@verisure.pe"),
                        "CORREOS_DESTINOS" => array("josejesus.cuadros@verisure.pe"),
                        "CORREOS_COPIA" => array(),
                        "CORREOS_OCULTO" => array(),
                        "ASUNTO" => $asunto,
                        "MENSAJE" => $cuerpo
                    );
            
                    $estadoCorreo = $this->complementos->enviarCorreoElectronico($configCorreo);
            
                    $dataCorreo = array(
                        "IDReposicion"  => $idReposicion,
                        "Response"      => $estadoCorreo['RESPUESTA'],
                        "Error"         => $estadoCorreo['ERROR'],
                        'UsuarioCrea'   => $this->items['id'],
                        'FechaCrea'     => $fechaActual,    
                        'Localhost'     => $this->request->getIPAddress()
                    );
            
                    $this->correoStatusReposicion->insert($dataCorreo, TRUE);
                }
                
                // $nuevaNotificacion['usuariodestino'] = $infoSolicitud['UsuarioCrea'];
                // $nuevaNotificacion['gtdestino'] = null;
                // $nuevaNotificacion['perfildestino'] = null;
                // $nuevaNotificacion['mensaje'] = "Se encuentra <span class='color-espe'>EN ESPERA LA GESTIÓN</span> de la petición #".$idPeticion.".";
            }
            else
            {
                $message = sprintf($this->mensajeError->msg201, "No cuenta con estado previo autorizado para concluir la evaluación. Inténtelo luego.[".$estado."]");
                echo $this->alertas->alertaError($message);
    			exit;
            }
        }
        
        $lastId = $this->solicitudReposicion->update([$idSolicitudReposicion], $dataSolicitud);

		if($lastId !== FALSE){
		    
		    /*
            * ----------------------------
            * INSERCIÓN DE NOTIFICACIÓN
            * ----------------------------
            */
            
            // if($estado != 'INIC')
            // {
            //     $this->insertarNotificacion($nuevaNotificacion);
            // }
		    
		    
			$message = sprintf($this->mensajeError->msg503, $idPeticion);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
}