<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

require 'vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;

class Monitoring extends BaseController
{
	public function __construct(){
		$this->clienteModelo = new \App\Models\ClienteModelo();
		$this->gestionModelo = new \App\Models\GestionModelo();
		$this->reincidenteModelo = new \App\Models\ReincidenteModelo();
		$this->accionModelo = new \App\Models\AccionModelo();
		$this->subAccionModelo = new \App\Models\SubAccionModelo();
	}

	public function listar(){
		if(isset($this->items['id'])){

			/* ACCIONES */
			$listaAcciones = $this->accionModelo
							->findAll();

			$data = array (
				'session' => 'on',
				'titulo' => 'Monitoring Reincidencias | Verisure',
				'breadcrumb' => 'Monitoring Reincidencias',
				'listaAcciones' => $listaAcciones
			);
			$data = array_merge($data, $this->items);
			return view('monitoring/listar',$data);			
		} else {
			return view('errors/500');
		}
	}

	public function listarClusterizacion(){
		if(isset($this->items['id'])){
			/* PRIMER DIA */
			$fecha_actual = date("Y-m-d");
			$primerDia = date("Y-m-01",strtotime($fecha_actual."- 2 month"));

			/* CLUSTERIZACION */
			$listaClusterizacion = $this->gestionModelo->clusterizacion($primerDia);

			$data = array (
				'session' => 'on',
				'titulo' => 'Clusterización | Verisure',
				'breadcrumb' => 'Clusterización',
				'listaClusterizacion' => $listaClusterizacion
			);
			$data = array_merge($data, $this->items);
			return view('monitoring/listar-clusterizacion',$data);			
		} else {
			return view('errors/500');
		}
	}

    public function listarMonitoringJson() {

        $listaMonitoring = $this->reincidenteModelo->listaGeneralReincidentes();

        foreach ($listaMonitoring as $items) {  
			
			if($items['fecha_gestion'] == '' || $items['fecha_gestion'] == NULL){
				$fechaGestion = "-";
			} else {
				$fechaGestion = date("d-m-Y H:i:s", strtotime($items['fecha_gestion']));
			}

			if($items['fecha_mantenimiento'] == '' || $items['fecha_mantenimiento'] == NULL){
				$fechaMantenimiento = "-";
			} else {
				$fechaMantenimiento = date("d-m-Y", strtotime($items['fecha_mantenimiento']));
			}

			if($items['status'] == "No Iniciado"){
				$color = "bg-dark";
			} else if ($items['status'] == "No Contactado" || $items['status'] == "Stand By"){
				$color = "bg-info";
			} else if ($items['status'] == "En Progreso"){
				$color = "bg-warning";
			} else if ($items['status'] == "Ilocalizable" || $items['status'] == "Inviable"){
				$color = "bg-danger";
			} else if ($items['status'] == "Completado"){
				$color = "bg-success";
			} else if ($items['status'] == "No aplica"){
				$color = "bg-primary";
			}

			$status = '<span class="badge '.$color.' text-light">'.$items['status'].'</span>';

			$boton = '<td class="text-center align-middle">
						<button class="btn btn-dark btn-sm ver-gestiones" data-bs-toggle="modal" data-bs-target="#verHistorico" data-id="'.$items['id_cliente'].'">
							<i class="ri-eye-line"></i>
						</button>
					</td>
					<td class="text-center align-middle">
						<button class="btn btn-dark btn-sm editar-instalacion" data-bs-toggle="modal" data-bs-target="#editarHeavyUser" data-recincidente-id="'.$items['reincidente_id'].'">
							<i class="ri-pencil-line"></i>
						</button>
					</td>';

            $resultado[] = array(
                (string) $items['numero_cliente'],
                (string) $items['categoria'],
                (string) date("d-m-Y", strtotime($items['fecha_reincidente'])),
                (string) $items['incidentes'],
                (string) $items['con_mantenimiento'],
                (string) $fechaMantenimiento,
                (string) $items['motivo'],
                (string) $items['gestionable'],
                (string) $items['accion'],
                (string) $items['subaccion'],
                (string) $status,
                (string) $fechaGestion,
				(string) $boton
            );
        }

        $resultado2 = array (
            'data' => $resultado
        );

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

        echo json_encode($resultado2, JSON_NUMERIC_CHECK);
    }

    public function listarMonitoringDataTable(){
        $orderBy = " ORDER BY ";

        foreach ($this->request->getGet('order') as $order) {
            $orderBy .= $order['column'] + 1 . " {$order['dir']}, ";
        }

        $orderBy = substr($orderBy, 0, -2);
        $where = '';
        $columns = $this->request->getGet('columns');
        $fields = ['c.numero_cliente','r.categoria','r.fecha_reincidente','r.incidentes','r.con_mantenimiento','r.fecha_mantenimiento','r.motivo','g.gestionable','a.accion','s.subaccion','g.status','g.fecha_gestion','c.id_cliente','c.reincidente_id'];
        $where = '';

        foreach ($columns as $k => $column) {
            if ($this->request->getGet('search')['value']!="") {
                $where .= $fields[$k]." LIKE '%".$this->request->getGet('search')['value']."%' OR ";
            } else {
				
			}
        }

        $where = substr($where, 0, -4);
        $length = $this->request->getGet('length');
        $start = $this->request->getGet('start'); 

        /* LISTAR ORDEN DE COMPRA */
        $listaReincidentes = $this->reincidenteModelo->listaGeneralReincidentes($orderBy,$where,$length,$start);
        echo json_encode($listaReincidentes, JSON_NUMERIC_CHECK);
    }

    public function grabarHeavyUsersBk() {
		if($_FILES["estructura"]["name"] != ''){
			$allowedExtensions = array("csv");
			$fileArray = explode(".", $_FILES["estructura"]["name"]);
			$fileExtension = end($fileArray);
			
			if(in_array($fileExtension, $allowedExtensions)){
				$tipo = $_FILES['estructura']['type'];
				$tamanio = $_FILES['estructura']['size'];
				$archivotmp = $_FILES['estructura']['tmp_name'];
				$lineas = file($archivotmp);

				$i = 0;
				foreach ($lineas as $linea) {
					if($i != 0){
						$datos = explode(";", $linea);

						$numeroInstalacion = !empty($datos[0])  ? ($datos[0]) : ''; //# INSTALACION
						$categoria = !empty($datos[1])  ? ($datos[1]) : ''; //CATEGORIA
						$fechaReincidencia = !empty($datos[2])  ? ($datos[2]) : ''; //FECHA REINCIDENCIA
						$incidencias = !empty($datos[3])  ? ($datos[3]) : ''; //INCIDENCIAS
						$conMantenimiento = !empty($datos[4])  ? ($datos[4]) : ''; //CON MANTENIMIENTO
						$fechaMantenimiento = !empty($datos[5])  ? ($datos[5]) : ''; //FECHA MANTENIMIENTO
						$motivo = !empty($datos[6])  ? ($datos[6]) : ''; //MOTIVO

                        if($incidencias == ''){
                            $incidencias = 0;
                        }

						if($fechaMantenimiento == ''){
							$fechaMantenimiento = NULL;
						} else {
							$fechaMantenimiento = date("Y-m-d", strtotime($fechaMantenimiento));
						}

						/* OBTENER INFORMACIÓN DE LA INSTALACIÓN */
                        $whereCliente = array (
                            'cliente.numero_cliente' => $numeroInstalacion,
                            'cliente.eliminacion_logica' => 1
                        );
                        $datosCliente = $this->clienteModelo
                                            ->where($whereCliente)
                                            ->findAll();

						/* GRABAR NUEVA REINCIDENCIA */
						$dataReincidente = array (
							'cliente_id' => $datosCliente[0]['id_cliente'],
							'categoria' => $categoria,
							'fecha_reincidente' => date("Y-m-d", strtotime($fechaIncidencia)),
							'incidentes' => $incidencias,
							'con_mantenimiento' => $conMantenimiento,
							'fecha_mantenimiento' => $fechaMantenimiento,
							'motivo' => $motivo,
							'fecha_registro' => date("Y-m-d H:i:s"),
							'eliminacion_logica' => 1
						);
						$lastIdReincidente = $this->reincidenteModelo->insert($dataReincidente, TRUE);

						if($datosCliente[0]['reincidente_id'] != NULL || $datosCliente[0]['reincidente_id'] != ""){
							/* OBTENER ÚLTIMA GESTIÓN */
							$whereGestion = array (
								'gestion.reincidente_id' => $datosCliente[0]['reincidente_id'],
								'gestion.eliminacion_logica' => 1
							);
							$datosGestion = $this->gestionModelo
											->where($whereGestion)
											->findAll();

							/* DUPLICAR GESTIÓN */
							$dataGestion = array (
								'reincidente_id' => $lastIdReincidente,
								'gestionable' => $datosGestion[0]['gestionable'],
								'accion' => $datosGestion[0]['accion'],
								'subaccion' => $datosGestion[0]['subaccion'],
								'status' => $datosGestion[0]['status'],
								'fecha_gestion' => NULL,
								'fecha_registro' => date("Y-m-d H:i:s"),
								'eliminacion_logica' => 1
							);
							$this->gestionModelo->insert($dataGestion, TRUE);

							/* ACTUALIZAR REINCIDENCIA EN CLIENTE */
							$dataCliente = array (
								'reincidente_id' => $lastIdReincidente
							);
							$this->clienteModelo->update([$datosCliente[0]['id_cliente']], $dataCliente);
						} else {
							/* CREAR GESTIÓN */
							$dataGestion = array (
								'reincidente_id' => $lastIdReincidente,
								'gestionable' => NULL,
								'accion' => NULL,
								'subaccion' => NULL,
								'status' => "No Iniciado",
								'fecha_gestion' => NULL,
								'fecha_registro' => date("Y-m-d H:i:s"),
								'eliminacion_logica' => 1
							);
							$this->gestionModelo->insert($dataGestion, TRUE);

							/* ACTUALIZAR REINCIDENCIA EN CLIENTE */
							$dataCliente = array (
								'reincidente_id' => $lastIdReincidente
							);
							$this->clienteModelo->update([$datosCliente[0]['id_cliente']], $dataCliente);
						}
					}
					$i++;
				}
			} else {
				$message = sprintf($this->mensajeError->msg201, "Extensión de archivo incorrecta");
				echo $this->alertas->alertaError($message);
				EXIT;
			}
		} else {
            $message = sprintf($this->mensajeError->msg201, "Por favor suba un archivo");
            echo $this->alertas->alertaError($message);
            EXIT;
		}
    }

    public function grabarHeavyUsers() {
		if($_FILES["estructura"]["name"] != ''){
			$allowedExtensions = array("xls","csv","xlsx");
			$fileArray = explode(".", $_FILES["estructura"]["name"]);
			$fileExtension = end($fileArray);
			
			if(in_array($fileExtension, $allowedExtensions)){
				$object = IOFactory::load($_FILES["estructura"]["tmp_name"]);
				$worksheet = $object->getSheet(0);

					$highestRow = $worksheet->getHighestRow();
					$highestColumn = $worksheet->getHighestColumn();
                    
					$error = '';
		
					// for ($row = 2; $row <= $highestRow; $row++) {
					// 	/* VALIDAR QUE EL CAMPO DE ID CLIENTE SIEMPRE ESTÉ LLENO SI HAY DATOS EN LAS OTRAS CELDAS */
					// 	if ($worksheet->getCellByColumnAndRow(1, $row)->getValue() == '') { //A1
					// 		if ($worksheet->getCellByColumnAndRow(2, $row)->getValue() != '') { //C1
					// 			$error .= '<li>Por favor especifique el ID de cliente en la fila '. $row .'</li>';
					// 		}
					// 	}
		
					// 	/* VALIDAR QUE AL MENOS UN CAMPO ESTÉ LLENO SI EL ID DE EMPLEADO ESTÁ LLENO */
					// 	if ($worksheet->getCellByColumnAndRow(1, $row)->getValue() != '') {
					// 		if ($worksheet->getCellByColumnAndRow(2, $row)->getValue() == '') {
					// 			$error .= '<li>Por favor especifique el abreviado en la fila '. $row .'</li>';
					// 		}
					// 	}
					// }
		
					// if ($error != '') {
					// 	$message = sprintf($this->mensajeError->msg201, $error);
					// 	echo $this->alertas->alertaError($message);
					// 	EXIT;
					// }
                    
					for ($row = 2; $row <= $highestRow; $row++) {                        
						$numeroInstalacion = $worksheet->getCellByColumnAndRow(1, $row)->getValue(); //NUMERO DE INSTALACION
                        $categoria = $worksheet->getCellByColumnAndRow(2, $row)->getValue(); //CATEGORÍA
                        $fechaIncidencia = $worksheet->getCellByColumnAndRow(3, $row)->getValue(); //FECHA
						$incidencias = $worksheet->getCellByColumnAndRow(4, $row)->getValue(); //# DE INCIDENCIAS
						$conMantenimiento = $worksheet->getCellByColumnAndRow(5, $row)->getValue(); //MANTENIMIENTO
						$fechaMantenimiento = $worksheet->getCellByColumnAndRow(6, $row)->getValue(); //FECHA DE MANTENIMIENTO
						/*$motivo = $worksheet->getCellByColumnAndRow(7, $row)->getValue();*/ //MOTIVO

                        if($incidencias == ''){
                            $incidencias = 0;
                        }

						if($fechaMantenimiento == ''){
							$fechaMantenimiento = NULL;
						} else {
							$fechaMantenimiento = date("Y-m-d", (($fechaMantenimiento  - 25568) * 86400));
						}

						/* OBTENER INFORMACIÓN DE LA INSTALACIÓN */
                        $whereCliente = array (
                            'cliente.numero_cliente' => $numeroInstalacion,
                            'cliente.eliminacion_logica' => 1
                        );
                        $datosCliente = $this->clienteModelo
                                            ->where($whereCliente)
                                            ->findAll();

						/* GRABAR NUEVA REINCIDENCIA */
						$dataReincidente = array (
							'cliente_id' => $datosCliente[0]['id_cliente'],
							'categoria' => $categoria,
							'fecha_reincidente' => date("Y-m-d", (($fechaIncidencia  - 25568) * 86400)),
							'incidentes' => $incidencias,
							'con_mantenimiento' => $conMantenimiento,
							'fecha_mantenimiento' => $fechaMantenimiento,
							/*'motivo' => $motivo,*/
							'fecha_registro' => date("Y-m-d H:i:s"),
							'eliminacion_logica' => 1
						);
						$lastIdReincidente = $this->reincidenteModelo->insert($dataReincidente, TRUE);

						if($datosCliente[0]['reincidente_id'] != NULL || $datosCliente[0]['reincidente_id'] != ""){
							/* OBTENER ÚLTIMA GESTIÓN */
							$whereGestion = array (
								'gestion.reincidente_id' => $datosCliente[0]['reincidente_id'],
								'gestion.eliminacion_logica' => 1
							);
							$datosGestion = $this->gestionModelo
											->where($whereGestion)
											->findAll();

							/* DUPLICAR GESTIÓN */
							$dataGestion = array (
								'reincidente_id' => $lastIdReincidente,
								'gestionable' => $datosGestion[0]['gestionable'],
								'accion_id' => $datosGestion[0]['accion_id'],
								'subaccion_id' => $datosGestion[0]['subaccion_id'],
								'status' => $datosGestion[0]['status'],
								'fecha_gestion' => NULL,
								'fecha_registro' => date("Y-m-d H:i:s"),
								'eliminacion_logica' => 1
							);
							$this->gestionModelo->insert($dataGestion, TRUE);

							/* ACTUALIZAR REINCIDENCIA EN CLIENTE */
							$dataCliente = array (
								'reincidente_id' => $lastIdReincidente
							);
							$this->clienteModelo->update([$datosCliente[0]['id_cliente']], $dataCliente);
						} else {
							/* CREAR GESTIÓN */
							$dataGestion = array (
								'reincidente_id' => $lastIdReincidente,
								'gestionable' => NULL,
								'accion_id' => 0,
								'subaccion_id' => 0,
								'status' => "No Iniciado",
								'fecha_gestion' => NULL,
								'fecha_registro' => date("Y-m-d H:i:s"),
								'eliminacion_logica' => 1
							);
							$this->gestionModelo->insert($dataGestion, TRUE);

							/* ACTUALIZAR REINCIDENCIA EN CLIENTE */
							$dataCliente = array (
								'reincidente_id' => $lastIdReincidente
							);
							$this->clienteModelo->update([$datosCliente[0]['id_cliente']], $dataCliente);
						}
					}

					$message = sprintf($this->mensajeError->msg502, "reincidencias");
					echo $this->alertas->alertaExito($message);
					echo $this->alertas->refrescar(1);
			} else {
				$message = sprintf($this->mensajeError->msg201, "Extensión de archivo incorrecta");
				echo $this->alertas->alertaError($message);
				EXIT;
			}
		} else {
            $message = sprintf($this->mensajeError->msg201, "Por favor suba un archivo");
            echo $this->alertas->alertaError($message);
            EXIT;
		}
    }

	public function actualizarGestion($idGestion){
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $gestionable = $this->request->getPost('gestionable');
        $accion = $this->request->getPost('accion');
        $subAccion = $this->request->getPost('subaccion');
        $estado = $this->request->getPost('estado');
        $fechaMantenimiento = $this->request->getPost('fecha_mantenimiento');
        $comentarios = $this->request->getPost('comentarios');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($gestionable, 'required|trim|name|minlength[1]|maxlength[50]', 'Gestionable');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|name|minlength[1]|maxlength[50]', 'Estado');
        $error .= $this->complementos->validaCampo($accion, 'required|trim|minlength[1]|maxlength[100]', 'Acción');
        $error .= $this->complementos->validaCampo($subAccion, 'required|trim|minlength[1]|maxlength[100]', 'Sub Acción');
		if($accion == 4 && $subAccion == 10){
			$error .= $this->complementos->validaCampo($fechaMantenimiento, 'required|trim|dateDos|minlength[1]|maxlength[100]', 'Fecha de Mantenimiento');
		} else {
			$error .= $this->complementos->validaCampo($fechaMantenimiento, 'trim|dateDos|minlength[1]|maxlength[100]', 'Fecha de Mantenimiento');
		}
        $error .= $this->complementos->validaCampo($comentarios, 'trim|minlength[1]|maxlength[1000]', 'Comentarios');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */	

		if($fechaMantenimiento == ''){
			$fechaMantenimiento = NULL;
			$conMantenimiento = 'Sin Mant. Agendado';
		} else {
			$conMantenimiento = 'Con Mant. Agendado';
		}
	
		$dataGestion = array (
			'gestionable' => $gestionable,
			'accion_id' => $accion,
			'subaccion_id' => $subAccion,
			'status' => $estado,
			'fecha_gestion' => date("Y-m-d H:i:s"),
			'comentarios' => $comentarios
		);
		$lastId = $this->gestionModelo->update([$idGestion], $dataGestion);

		/* OBTENER DATOS DE LA GESTION */
		$whereGestion = array (
			'id_gestion' => $idGestion,
		);
		$datosGestion = $this->gestionModelo->where($whereGestion)->findAll();

		/* ACTUALIZAR REINCIDENCIA */
		$dataReincidente = array (
			'fecha_mantenimiento' => $fechaMantenimiento,
			'con_mantenimiento' => $conMantenimiento
		);
		$this->reincidenteModelo->update([$datosGestion[0]['reincidente_id']], $dataReincidente);
	
		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, "gestión");
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}

	public function reporteHeavyUsers(){
		$excel = new Spreadsheet();		
		$worksheet = $excel->getActiveSheet(0);

        foreach (range('A', 'M') as $columnID) {
            $excel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
            $excel->getActiveSheet()->getStyle("A:M")->getFont()->setSize(9);
            $excel->getActiveSheet()->getStyle("A:M")->getAlignment()->setHorizontal('center');
            $excel->getActiveSheet()->getStyle('A:M')->getAlignment()->setVertical(\PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER);
        }
        $excel->getActiveSheet()->getRowDimension(3)->setRowHeight(26);
		$excel->getActiveSheet()->getStyle('A3:M3')->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('000000');

		$worksheet->setTitle("REPORTE");

		/* CABECERAS */
        $worksheet->setCellValue('A1', 'Reporte de Heavy Users ' . date('Y-m-d') . '.')->getStyle('A1')->getFont()->setBold(true);
		$worksheet->setCellValue('A3','N° Instalación')->getStyle('A3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('B3','Fecha Instalación')->getStyle('B3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('C3','Fecha Acción')->getStyle('C3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('D3','Estado')->getStyle('D3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('E3','Acción')->getStyle('E3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('F3','Subacción')->getStyle('F3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('G3','# Eventos')->getStyle('G3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('H3','Días c/ Eventos')->getStyle('H3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('I3','Ratio Día')->getStyle('I3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('J3','Ratio Prev')->getStyle('J3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('K3','Ratio Atc')->getStyle('K3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('L3','Días HU')->getStyle('L3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$worksheet->setCellValue('M3','Reducción')->getStyle('M3')->getFont()->setBold(true)->setSize(10)->getColor()->setRGB('ffffff');
		$rows = 4;
        $i = 1;
        $format = "dd/mm/yyyy";
		
		/* LISTAR MONITORING */
		$listaMonitoring = $this->monitoringModelo->listaGeneralMonitoring2();
		
		if($listaMonitoring == FALSE){
			$listaMonitoring = array();
		}

		foreach($listaMonitoring as $items){	
			if($items['fecha_accion'] != ''){
				$ratioDia = $items['totalEventos'] / $items['diasEventos'];
				$ratioPrev = $items['totalIncidenciasPrev'] / $items['totalDiasPrev'];
				$ratioAct = $items['totalIncidenciasAct'] / $items['totalDiasAct'];
				$reduccion = (($ratioAct / $ratioPrev) - 1) * 100;
				$fechaAccion = date("d-m-Y", strtotime($items['fecha_accion']));
			} else {
				$ratioDia = 0;
				$ratioPrev = 0;
				$ratioAct = 0;
				$reduccion = 0;
				$fechaAccion = "-";
			}
			
            $excel->getActiveSheet()->getRowDimension($rows)->setRowHeight(26);

			$worksheet->setCellValue('A' . $rows, $items['numero_instalacion']);
			$worksheet->setCellValue('B' . $rows, date("d-m-Y", strtotime($items['fecha_instalacion'])));
			$worksheet->setCellValue('C' . $rows, $fechaAccion);
			$worksheet->setCellValue('D' . $rows, $items['estado']);
			$worksheet->setCellValue('E' . $rows, $items['accion']);
			$worksheet->setCellValue('F' . $rows, $items['sub_accion']);
			$worksheet->setCellValue('G' . $rows, number_format($items['totalEventos'], 2, '.', ' '));
			$worksheet->setCellValue('H' . $rows, number_format($items['diasEventos'], 2, '.', ' '));
			$worksheet->setCellValue('I' . $rows, number_format($ratioDia, 2, '.', ' '));
			$worksheet->setCellValue('J' . $rows, number_format($ratioPrev, 2, '.', ' '));
			$worksheet->setCellValue('K' . $rows, number_format($ratioAct, 2, '.', ' '));
			$worksheet->setCellValue('L' . $rows, $items['diasHu']);
			$worksheet->setCellValue('M' . $rows, number_format($reduccion, 2, '.', ' ') . "%");

			$rows++; $i++;
		}

		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Reporte de Heavy Users - "'.date("d-m-Y H:i:s").'".xlsx"');
		header('Cache-Control: max-age=0');
		
		$writer = IOFactory::createWriter($excel, 'Xlsx');
		$writer->save('php://output');
		exit;
	}	
}