<?php

namespace App\Controllers;
use \App\Libraries\Complementos;
use \App\Libraries\Scripts;
use \App\Libraries\Error;
use \App\Libraries\Alertas;
use \App\Libraries\Pdf;

class Configuracion extends BaseController
{
	public function __construct(){
	    
        $this->elementosDemo = new \App\Models\ElementosDemoModel();
	}

	public function listarElementosDemo()
	{
    	if(isset($this->items['id'])){

			/* ACCIONES */
			$listaElementosDemo = $this->elementosDemo->findAll();
			
			$data = array (
				'session'               => 'on',
				'titulo'                => 'Elementos Demo | Verisure',
				'breadcrumb'            => $this->items['modulo'],
				'breadcrumb_alias'      => 'Elementos Demo',
				'listaElementosDemo'    => $listaElementosDemo
			);
			$data = array_merge($data, $this->items);
			return view('configuracion/listar_elementos_demo',$data);			
		} else {
			return view('errors/500');
		}	
	}

	public function insertarElementoDemo()
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $nombreElemento     = ucwords(mb_strtolower($this->request->getPost('txtNombreElementoDemo_i')));
        $skuElemento        = $this->request->getPost('txtSKUElementoDemo_i');
        $observacion        = $this->request->getPost('txtObservacionElementoDemo_i');
        $precioReposicion   = $this->request->getPost('txtPrecioReposicionElementoDemo_i');

        
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($nombreElemento, 'required|trim|minlength[1]|maxlength[150]', 'Descripción');
        $error .= $this->complementos->validaCampo($skuElemento, 'required|trim|minlength[1]|maxlength[30]', 'SKU');
        $error .= $this->complementos->validaCampo($precioReposicion, 'required|trim|minlength[1]|maxlength[30]', 'Precio Reposición');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * VALIDACIÓN DE EXISTENCIA
        * ----------------------------
        */

        $msgExistencia = '';
        
        $whereExistencia = array(
            "SKU"   => $skuElemento
        );
        
		$elementoExistente = $this->elementosDemo->where($whereExistencia)->findAll();
        
        if(count($elementoExistente)>0)
        {
            $msgExistencia .= "<li>El SKU ya fue registrado. [CAMPO] <small>SKU</small></li>";
        }

        if($msgExistencia != '')
        {
            $message = sprintf($this->mensajeError->msg201, $msgExistencia);
            echo $this->alertas->alertaPeligro($message);
            EXIT;
        }
        
        /*
        * ----------------------------
        * BASE DE DATOS
        * ----------------------------
        */

        $data = array (
            'SKU'           => $skuElemento,
            'Nombre'        => $nombreElemento,
            'Observacion'   => $observacion,
            'PrecioReposicion'  => $precioReposicion,
            'UsuarioCrea'   => $this->items['id'],
            'FechaCrea'     => $fechaActual,    
            'Localhost'     => $this->request->getIPAddress(),
            'UsuarioEstado' => $this->items['id'],
            'FechaEstado'   => $fechaActual,    
            'MotivoEstado'  => "Creación de elemento.",    
            'Estado'        => 'A'
        );

        $lastId = $this->elementosDemo->insert($data, TRUE);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg502, $nombreElemento);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
	}
	
	public function obtenerDatosElementoDemo()
	{
		/*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
		*/

		$msjError = TRUE;
		$idElementoDemo = $this->request->getPost('idElementoDemo');

		/*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

		$error = '';
		$error .= $this->complementos->validaCampo($idElementoDemo, 'trim', 'ID');

		if ($error != '') {
			$message = sprintf($this->mensajeError->msg201, $error);
			echo $this->alertas->alertaError($message);
			exit;
		}

		/*
        * -------------
        * BASE DE DATOS
        * -------------
        */
		
		$datosElementoDemo = $this->elementosDemo->where('IDElementoDemo', $idElementoDemo)->first();

		if(!empty($datosElementoDemo)){
			$resultado = array(
				'idelementodemo'    => (string) $idElementoDemo,
				'sku'               => (string) $datosElementoDemo['SKU'],
				'detalle'           => (string) $datosElementoDemo['Nombre'],
				'observacion'       => (string) $datosElementoDemo['Observacion'],
				'precio'            => (string) $datosElementoDemo['PrecioReposicion']
			);
		} else {
			$resultado = array(
				'descripcion' => 0
			);
		}

		/*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */

		echo json_encode($resultado);		
	}
	
	public function modificarElementoDemo($idElementoDemo)
	{
        $fechaActual = date("Y-m-d H:i:s");
        
        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */
        
        $nombreElemento = ucwords(mb_strtolower($this->request->getPost('txtNombreElementoDemo_i')));
        $skuElemento    = $this->request->getPost('txtSKUElementoDemo_i');
        $observacion    = $this->request->getPost('txtObservacionElementoDemo_i');
        $precioReposicion    = $this->request->getPost('txtPrecioReposicionElementoDemo_i');
        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */
        
        $error = '';
        $error .= $this->complementos->validaCampo($nombreElemento, 'required|trim|minlength[1]|maxlength[150]', 'Descripción');
        $error .= $this->complementos->validaCampo($skuElemento, 'required|trim|minlength[1]|maxlength[30]', 'SKU');
        $error .= $this->complementos->validaCampo($precioReposicion, 'required|trim|minlength[1]|maxlength[30]', 'Precio Reposición');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }
        /*
        * -------------
        * BASE DE DATOS
        * -------------
        */            
		
        $data = array (
            'SKU'               => $skuElemento,
            'Nombre'            => $nombreElemento,
            'Observacion'       => $observacion,
            'PrecioReposicion'  => $precioReposicion,
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress()
        );

        $lastId = $this->elementosDemo->update([$idElementoDemo], $data);

        if($lastId !== FALSE){
            $message = sprintf($this->mensajeError->msg503, $nombreElemento);
            echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
        }
	}
	
    public function modificarEstadoElementoDemo()
    {
        $fechaActual = date("Y-m-d H:i:s");

        /*
        * ----------------------------
        * DATOS DE AJAX PRE PROCESADOS
        * ----------------------------
        */

        $msjError = TRUE;
        $idElementoDemo = $this->request->getPost('idElementoDemo');
        $estado = $this->request->getPost('estado');
        $motivo = $this->request->getPost('motivo');

        /*
        * ----------------------------
        * VALIDACIÓN DE REQUERIMIENTOS
        * ----------------------------
        */

        $error = '';
        $error .= $this->complementos->validaCampo($idElementoDemo, 'required|trim|numeric', 'ID Elemento Demo');
        $error .= $this->complementos->validaCampo($estado, 'required|trim|alpha|minlength[1]|maxlength[1]', 'Estado');
        $error .= $this->complementos->validaCampo($motivo, 'required|trim', 'Motivo');

        if ($error != '') {
            $message = sprintf($this->mensajeError->msg201, $error);
            echo $this->alertas->alertaError($message);
            EXIT;
        }

        $data = array (
            'UsuarioModifica'   => $this->items['id'],
            'FechaModifica'     => $fechaActual,    
            'Localhost'         => $this->request->getIPAddress(),
            'UsuarioEstado'     => $this->items['id'],
            'FechaEstado'       => $fechaActual,
            'MotivoEstado'      => $motivo,
            'Estado'            => $estado
        );
        
        $lastId = $this->elementosDemo->update([$idElementoDemo], $data);

		if($lastId !== FALSE){
			$message = sprintf($this->mensajeError->msg503, $idElementoDemo);
			echo $this->alertas->alertaExito($message);
			echo $this->alertas->refrescar(1);
		}
    }
    
    public function listadoElementosDemo()
    {
        if(isset($this->items['id']))
        {
            // $tipoRequerimiento = $this->request->getPost("tipoRequerimiento");
            
            // if($tipoRequerimiento != '' && $tipoRequerimiento != null && $tipoRequerimiento != "undefined")
            // {
            //     $where = array(
            //         "perfil"    => $this->items['idPerfil'],
            //         "estado"    => "A",
            //         "tipo"      => $tipoRequerimiento);
                
            //     $listado = $this->requerimientos->listadoRequerimientos($where);
            // }
            // else
            // {
            //     $listado = $this->requerimientos->findAll();
            // }
            
            $listado = $this->elementosDemo->where("Estado", "A")->findAll();
            
            $elementos=array();
    
    		if (!empty($listado)) {
                foreach ($listado as $items) {
                    $elementos[] = array(
    					'id' => (string) $items['IDElementoDemo'],
                        'text' => (string) $items['SKU'].' | '.$items['Nombre']
                    );
                }
    
                $resultado = array(
    				'listadoElementosDemo' => json_encode($elementos)
    			);
            } else {
    			$resultado = array(
    				'descripcion' => 0,
    			);
    		}
        } 
        else 
        {
    		$resultado = array(
				'descripcion' => 0,
			);
		}

        /*
         * ----------------------------
         * DATOS DE AJAX PRE PROCESADOS
         * ----------------------------
         */
        echo json_encode($resultado, JSON_NUMERIC_CHECK);	
    }
}