<?php

namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php'))
{
	require SYSTEMPATH . 'Config/Routes.php';
}

/**
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Acceso');
$routes->setDefaultMethod('login');
$routes->setTranslateURIDashes(false);
/* 404 PERSONALIZADO */
$routes->set404Override(function()
{
    echo view('errors/404');
});
$routes->setAutoRoute(true);

/*
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('/', 'Acceso::login');

/* ACCESO */
$routes->add('entrar','Acceso::entrar');
$routes->add('salir','Acceso::salir');
$routes->add('iniciar-sesion','Acceso::login');
$routes->add('olvido-contrasena', 'Acceso::olvidoContrasena');
$routes->add('solicitar-recuperacion', 'Acceso::solicitarRecuperacion');
$routes->add('recuperar-cuenta/(:any)', 'Acceso::recuperarCuenta/$1');
$routes->add('grabar-recuperacion/(:any)', 'Acceso::grabarRecuperacion/$1');

/* CLIENTES */
$routes->add('listar-clientes','Clientes::listar');
//$routes->add('listar-clientes-json','Clientes::listarClientesJson');
$routes->add('clientesServerside','Clientes::listarClienteDataTable');
$routes->add('grabar-clientes','Clientes::grabarClientes');
$routes->add('obtener-datos-instalacion','Clientes::obtenerDatosInstalacion');
$routes->add('obtener-gestiones-cliente','Clientes::obtenerGestionesCliente');

/* MONITORING */
$routes->add('listar-monitoring','Monitoring::listar');
//$routes->add('listar-monitoring-json','Monitoring::listarMonitoringJson');
$routes->add('clientesServersideMonitoring','Monitoring::listarMonitoringDataTable');
$routes->add('actualizar-gestion/(:any)','Monitoring::actualizarGestion/$1');
$routes->add('reporte-heavyusers','Monitoring::reporteHeavyUsers');
$routes->add('grabar-heavy-users','Monitoring::grabarHeavyUsers');
$routes->add('listar-clusterizacion','Monitoring::listarClusterizacion');

/* ADMINISTRACIÓN */
$routes->add('descargatxt/(:any)','Administracion::descargatxt/$1');/* NUEVO */

$routes->add('listado-direccion-estructura','Administracion::listadoDireccionesEstructura');/* NUEVO */
$routes->add('listado-area-estructura','Administracion::listadoAreasEstructura');/* NUEVO */
$routes->add('listado-subarea-estructura','Administracion::listadoSubareasEstructura');/* NUEVO */

$routes->add('subacciones','Administracion::subacciones');
$routes->add('listar-usuarios','Administracion::listarUsuarios');/* NUEVO */
$routes->add('obtener-datos-tipo-cambio','Administracion::obtenerTipoCambio');

$routes->add('listar-perfiles','Administracion::listarPerfiles');/* NUEVO */
$routes->add('registrar-perfil','Administracion::registrarPerfil');/* NUEVO */
$routes->add('listado-perfil-select','Administracion::listadoPerfilesSelect');/* NUEVO */
$routes->add('obtener-datos-perfil','Administracion::obtenerDatosPerfil');/* NUEVO */
$routes->add('actualizar-perfil/(:any)','Administracion::actualizarPerfil/$1');/* NUEVO */
$routes->add('cambiar-estado-perfil','Administracion::modificarEstadoPerfil');/* NUEVO */
//$routes->add('reactivar-perfil/(:any)','Administracion::reactivarPerfil/$1');
$routes->add('listar-permisos-perfil/(:any)','Administracion::listarPermisosPerfil/$1');/* NUEVO */
$routes->add('grabar-permisos-perfil/(:any)','Administracion::guardarPermisosPerfil/$1');/* NUEVO */
$routes->add('listar-rutas-perfil/(:any)','Administracion::listarRutasPerfil/$1');/* NUEVO */
$routes->add('grabar-rutas-perfil/(:any)','Administracion::guardarRutasPerfil/$1');/* NUEVO */

$routes->add('listado-direccion','Administracion::listadoDireccion'); /* NUEVO */

$routes->add('obtener-cabecera','Administracion::obtenerCabecera');/* NUEVO */
$routes->add('listar-modulos','Administracion::listarModulos');/* NUEVO */
$routes->add('registrar-modulo','Administracion::registrarModulo');/* NUEVO */
$routes->add('cambiar-estado-modulo','Administracion::modificarEstadoModulo');/* NUEVO */
$routes->add('obtener-datos-modulo','Administracion::obtenerDatosModulo');/* NUEVO */
$routes->add('actualizar-modulo/(:any)','Administracion::modificarModulo/$1');/* NUEVO */
$routes->add('listar-rutas-modulo/(:any)','Administracion::listarRutasModulo/$1');/* NUEVO */
$routes->add('grabar-ruta/(:any)','Administracion::guardarRutaModulo/$1');/* NUEVO */
$routes->add('obtener-datos-ruta-modulo','Administracion::obtenerDatosRutaModulo');/* NUEVO */
$routes->add('actualizar-ruta-modulo/(:any)','Administracion::modificarRutaModulo/$1');/* NUEVO */
$routes->add('cambiar-estado-ruta-modulo','Administracion::modificarEstadoRutaModulo');/* NUEVO */
$routes->add('listar-acciones-modulo/(:any)','Administracion::listarAccionesModulo/$1');/* NUEVO */
$routes->add('grabar-accion/(:any)','Administracion::guardarAccionModulo/$1');/* NUEVO */

$routes->add('listar-informacion-legal','Administracion::listarInformacionLegal');/* NUEVO */
$routes->add('registrar-informacion-legal','Administracion::registrarInformacionLegal');/* NUEVO */
$routes->add('obtener-datos-informacion-legal','Administracion::obtenerDatosInformacionLegal');/* NUEVO */
$routes->add('actualizar-informacion-legal/(:any)','Administracion::modificarInformacionLegal/$1');/* NUEVO */
/* CONFIGURACIÓN */

$routes->add('listar-categorias','Administracion::listarCategorias');/* NUEVO */
$routes->add('registrar-categoria','Administracion::registrarCategoria');/* NUEVO */
$routes->add('obtener-datos-categoria','Administracion::obtenerDatosCategoria');/* NUEVO */
$routes->add('actualizar-categoria/(:any)','Administracion::modificarCategoria/$1');/* NUEVO */
$routes->add('cambiar-estado-categoria','Administracion::modificarEstadoCategoria');/* NUEVO */

$routes->add('listar-tipos-categoria/(:any)','Administracion::listarTiposCategoria/$1');/* NUEVO */
$routes->add('registrar-tipo-categoria','Administracion::registrarTipoCategoria');/* NUEVO */
$routes->add('obtener-datos-tipo-categoria','Administracion::obtenerDatosTipoCategoria');/* NUEVO */
$routes->add('actualizar-tipo-categoria/(:any)','Administracion::modificarTipoCategoria/$1');/* NUEVO */
$routes->add('cambiar-estado-tipo-categoria','Administracion::modificarEstadoTipoCategoria');/* NUEVO */

$routes->add('listar-subtipos-tipo/(:any)','Administracion::listarSubtiposTipoCategoria/$1');/* NUEVO */
$routes->add('registrar-subtipo-tipo','Administracion::registrarSubtipoTipoCategoria');/* NUEVO */
$routes->add('obtener-datos-subtipo-tipo','Administracion::obtenerDatosSubtipoTipoCategoria');/* NUEVO */
$routes->add('actualizar-subtipo-tipo/(:any)','Administracion::modificarSubtipoTipoCategoria/$1');/* NUEVO */
$routes->add('cambiar-estado-subtipo-tipo','Administracion::modificarEstadoSubtipoTipoCategoria');/* NUEVO */

$routes->add('obtener-categorias','Veriactivos::obtenerCategorias');
$routes->add('obtener-tipos','Veriactivos::obtenerTipos');
$routes->add('obtener-subtipos','Veriactivos::obtenerSubtipos');

$routes->add('listar-marcas','Veriactivos::listarMarcas');
$routes->add('registrar-marca','Veriactivos::insertarMarca');
$routes->add('obtener-datos-marca','Veriactivos::obtenerDatosMarca');
$routes->add('actualizar-marca/(:any)','Veriactivos::modificarMarca/$1');
$routes->add('cambiar-estado-marca','Veriactivos::modificarEstadoMarca/$1');
$routes->add('obtener-marcas','Veriactivos::obtenerMarcas');

$routes->add('listar-dispositivos/(:any)','Veriactivos::listarDispositivos/$1');
$routes->add('obtener-datos-dispositivo','Veriactivos::obtenerDatosDispositivos');
$routes->add('registrar-dispositivo','Veriactivos::insertarDispositivo');
$routes->add('actualizar-dispositivo/(:any)','Veriactivos::modificarDispositivo/$1');
$routes->add('cambiar-estado-dispositivo','Veriactivos::modificarEstadoDispositivo/$1');
$routes->add('obtener-dispositivos','Veriactivos::obtenerDispositivos');

$routes->add('listar-operadores','Veriactivos::listarOperadores');
$routes->add('registrar-operador','Veriactivos::insertarOperador');
$routes->add('obtener-datos-operador','Veriactivos::obtenerDatosOperador');
$routes->add('actualizar-operador/(:any)','Veriactivos::modificarOperador/$1');
$routes->add('cambiar-estado-operador','Veriactivos::modificarEstadoOperador/$1');
$routes->add('obtener-operadores','Veriactivos::obtenerOperadores');

$routes->add('listar-planes/(:any)','Veriactivos::listarPlanes/$1');
$routes->add('registrar-plan','Veriactivos::insertarPlan');
$routes->add('obtener-datos-plan','Veriactivos::obtenerDatosPlan');
$routes->add('actualizar-plan/(:any)','Veriactivos::modificarPlan/$1');
$routes->add('cambiar-estado-plan','Veriactivos::modificarEstadoPlan/$1');
$routes->add('obtener-planes','Veriactivos::obtenerPlanes');

$routes->add('listar-elementos-demo','Configuracion::listarElementosDemo');
$routes->add('registrar-elemento-demo','Configuracion::insertarElementoDemo');
$routes->add('obtener-datos-elemento-demo','Configuracion::obtenerDatosElementoDemo');
$routes->add('actualizar-elemento-demo/(:any)','Configuracion::modificarElementoDemo/$1');
$routes->add('cambiar-estado-elemento-demo','Configuracion::modificarEstadoElementoDemo/$1');
$routes->add('listado-elementos-demo','Configuracion::listadoElementosDemo');

/* URES */

$routes->add('listar-kits-demo','Ures::listarKitsDemo');
// $routes->add('listado-nuevos-item-kit-demo','Ures::listadoNuevosItemKitDemo');
$routes->add('obtener-nuevo-item-kit-demo','Ures::obtenerNuevoItemKitDemo');
$routes->add('subir-csv-kits-demo','Ures::subirCSVKitsDemo');
$routes->add('registrar-kit-demo','Ures::insertarKitDemo');
$routes->add('obtener-datos-item-kit-demo','Ures::obtenerDatosItemKitDemo');
$routes->add('actualizar-item-kit-demo/(:any)','Ures::modificarItemKitDemo/$1');

/* CARGOS */

$routes->add('listar-asignaciones','Cargos::listarAsignaciones');
$routes->add('obtener-elemento-a-asignar','Cargos::obtenerElementoAsignar');
$routes->add('obtener-elementos-asignacion','Cargos::obtenerElementosAsignacion');
$routes->add('guardar-asignacion','Cargos::guardarAsignacion');
$routes->add('documento-asignado/(:any)','Cargos::documentoAsociado/$1');
$routes->add('enviar-correo-asignacion','Cargos::enviarCorreoAsignacion');
$routes->add('acta-asignacion/(:any)/(:any)','Cargos::actaAsignacion/$1/$2');
$routes->add('detalle-acta-asignacion/(:any)','Cargos::detalleActaAsignacion/$1');
$routes->add('subir-firma-acta-asignacion','Cargos::subirFirmaActaAsignacion');
$routes->add('adjuntar-documento-asignacion/(:any)','Cargos::adjuntarDocumentoAsignacion/$1');
$routes->add('subir-csv-asignacion','Cargos::subirCSVAsignacion');

$routes->add('listar-reposiciones','Cargos::listarReposiciones');
// $routes->add('guardar-reposicion','Cargos::registrarReposicion');
$routes->add('documento-reposicion/(:any)','Cargos::documentoReposicion/$1');
$routes->add('detalle-acta-reposicion/(:any)','Cargos::detalleActaReposicion/$1');
$routes->add('enviar-correo-reposicion','Cargos::enviarCorreoReposicion');
$routes->add('acta-reposicion/(:any)/(:any)','Cargos::actaReposicion/$1/$2');
$routes->add('subir-firma-acta-reposicion','Cargos::subirFirmaActaReposicion');

$routes->add('listar-devoluciones','Cargos::listarDevoluciones');
$routes->add('nueva-devolucion','Cargos::nuevaDevolucion');
$routes->add('pendientes-devolucion','Cargos::listadoPendientesDevolucionUsuario');
$routes->add('guardar-devolucion','Cargos::registrarDevolucion');
$routes->add('documento-devolucion/(:any)','Cargos::documentoDevolucion/$1');
$routes->add('enviar-correo-devolucion','Cargos::enviarCorreoDevolucion');
$routes->add('acta-devolucion/(:any)/(:any)','Cargos::actaDevolucion/$1/$2');
$routes->add('detalle-acta-devolucion/(:any)','Cargos::detalleActaDevolucion/$1');
$routes->add('subir-firma-acta-devolucion','Cargos::subirFirmaActaDevolucion');
$routes->add('adjuntar-documento-devolucion/(:any)','Cargos::adjuntarDocumentoDevolucion/$1');

$routes->add('listar-descuentos-mensual','Cargos::listarDescuentosMensual');
$routes->add('recargar-descuento-mensual','Cargos::recargarTablaDescuentoMensual');
$routes->add('exportar-descuento-mensual/(:any)/(:any)','Cargos::exportarDescuentoMensual/$1/$2');
$routes->add('importar-descuento-mensual','Cargos::importarDescuentosMensual');




// $routes->add('nueva-asignacion','Veriactivos::nuevaAsignacion');
// $routes->add('obtener-monto-reposicion','Veriactivos::obtenerMontoReposicion');

// $routes->add('nueva-reposicion','Veriactivos::nuevaReposicion');
// $routes->add('obtener-monto-descuento-reposicion','Veriactivos::obtenerMontoDescuentoReposicion');



// $routes->add('listar-asignaciones-ures','Cargos::listarAsignacionesURES');



/* IT */

$routes->add('listar-accesorios-it','Veriactivos::listarAccesoriosIT');
$routes->add('registrar-accesorio-it','Veriactivos::insertarAccesorioIT');
$routes->add('obtener-datos-accesorio-it','Veriactivos::obtenerDatosAccesorioIT');
$routes->add('actualizar-accesorio-it/(:any)','Veriactivos::modificarAccesorioIT/$1');









/* USUARIOS */
$routes->add('usuariosServerside','Usuarios::listarUsuarioDataTable');/* NUEVO */
$routes->add('obtener-datos-usuario','Usuarios::obtenerDatosUsuario');
$routes->add('modificar-usuario/(:any)','Usuarios::modificarUsuario/$1');/* NUEVO */

$routes->add('listado-usuarios-select','Usuarios::listadoUsuariosSelect');

$routes->add('listar-permisos-usuario/(:any)','Usuarios::listarPermisosUsuario/$1');/* NUEVO */
$routes->add('grabar-permisos-usuario/(:any)','Usuarios::guardarPermisosUsuario/$1');/* NUEVO */
$routes->add('listar-rutas-usuario/(:any)','Usuarios::listarRutasUsuario/$1');/* NUEVO */
$routes->add('grabar-rutas-usuario/(:any)','Usuarios::guardarRutasUsuario/$1');/* NUEVO */
/* VERIACTIVOS */ /* NUEVO */

$routes->add('listar-moviles','Veriactivos::listarMoviles');
$routes->add('grabar-movil','Veriactivos::insertarMovil');
$routes->add('obtener-datos-movil','Veriactivos::obtenerDatosMovil');
$routes->add('actualizar-movil/(:any)','Veriactivos::modificarMovil/$1');
$routes->add('obtener-estados-movil','Veriactivos::obtenerEstadosMovil');
$routes->add('obtener-motivos-estado-movil','Veriactivos::obtenerMotivoEstadoMovil');
$routes->add('exportar-movil/(:any)','Veriactivos::exportarMovil/$1');

$routes->add('listar-lineas','Veriactivos::listarLineas');
$routes->add('obtener-datos-linea','Veriactivos::obtenerDatosLinea');
$routes->add('actualizar-linea/(:any)','Veriactivos::modificarLinea/$1');
$routes->add('grabar-linea','Veriactivos::insertarLinea');
$routes->add('obtener-estados-linea','Veriactivos::obtenerEstadosLinea');
$routes->add('obtener-motivos-estado-linea','Veriactivos::obtenerMotivoEstadoLinea');
$routes->add('subir-csv-linea','Veriactivos::subirCSVLinea');
$routes->add('exportar-linea/(:any)','Veriactivos::exportarLinea/$1');

$routes->add('listar-tarjetas-acceso','Veriactivos::listarTarjetasAcceso');
$routes->add('obtener-datos-tarjeta-acceso','Veriactivos::obtenerDatosTarjetaAcceso');
$routes->add('actualizar-tarjeta-acceso/(:any)','Veriactivos::modificarTarjetaAcceso/$1');
$routes->add('registrar-tarjeta-acceso','Veriactivos::insertarTarjetaAcceso');
$routes->add('subir-csv-tarjeta-acceso','Veriactivos::subirCSVTarjetaAcceso');
//$routes->add('obtener-estados-linea','Veriactivos::obtenerEstadosLinea');
//$routes->add('obtener-motivos-estado-linea','Veriactivos::obtenerMotivoEstadoLinea');

$routes->add('listado-direcciones-tarjeta-acceso','Veriactivos::listadoDireccionesTarjetaAcceso');
$routes->add('grabar-direcciones-tarjeta-acceso/(:any)','Veriactivos::guardarDireccionesTarjetaAcceso/$1');
$routes->add('listar-ubicaciones-tarjeta-acceso/(:any)','Veriactivos::listarUbicacionesTarjetaAcceso/$1');
$routes->add('grabar-ubicaciones-tarjeta-acceso/(:any)','Veriactivos::guardarUbicacionesTarjetaAcceso/$1');

$routes->add('listar-hardware','Veriactivos::listarHardware');
$routes->add('obtener-datos-hardware','Veriactivos::obtenerDatosHardware');
$routes->add('actualizar-hardware/(:any)','Veriactivos::modificarHardware/$1');
$routes->add('registrar-hardware','Veriactivos::insertarHardware');
$routes->add('subir-csv-hardware','Veriactivos::subirCSVHardware');

$routes->add('contrato-linea/(:any)','Veriactivos::contratoLinea/$1');
$routes->add('grabar-contrato','Veriactivos::insertarContrato');
$routes->add('obtener-datos-contrato','Veriactivos::obtenerDatosContrato');
$routes->add('actualizar-contrato/(:any)','Veriactivos::modificarContrato/$1');
$routes->add('validar-contrato-linea-actual','Veriactivos::validarContratoLineaActual');

$routes->add('seguro-linea/(:any)','Veriactivos::seguroLinea/$1');
$routes->add('listado_moviles_seguro/(:any)','Veriactivos::listadoMovilesSeguro/$1');
$routes->add('grabar-movil-seguro','Veriactivos::insertarMovilSeguro');
$routes->add('obtener-datos-seguro','Veriactivos::obtenerDatosSeguro');
$routes->add('actualizar-seguro/(:any)','Veriactivos::modificarSeguro/$1');

//$routes->add('listar-usuarios-asignados','Veriactivos::listarUsuariosAsignados');
//$routes->add('listar-asignaciones/(:any)','Veriactivos::listarAsignaciones/$1');

/* SOLICITUDES */

$routes->add('listar-paqueteria','Paqueteria::listadoPaqueteria');
$routes->add('nueva-paqueteria','Paqueteria::nuevaPaqueteria');

$routes->add('listado-cc-select','Paqueteria::listadoCCSelect');
$routes->add('listado-usuarios-cc','Paqueteria::listadoUsuariosCCSelect');
$routes->add('listado-elemento-paqueteria-select','Paqueteria::listadoElementoPaqueteriaSelect');
$routes->add('guardar-paqueteria','Paqueteria::guardarPaqueteria');
$routes->add('timeline-paqueteria/(:any)','Paqueteria::timelinePaqueteria/$1');
$routes->add('guardar-estado-paqueteria/(:any)','Paqueteria::guardarEstadoPaqueteria/$1');
$routes->add('guia-remision-paqueteria/(:any)','Paqueteria::guiaRemisionPaqueteria/$1');

$routes->add('solicitudes-reposicion','Solicitudes::listarSolicitudesReposicion');
$routes->add('listado-items-asignados','Solicitudes::listadoItemsAsignados');
$routes->add('obtener-elemento-a-reponer','Solicitudes::obtenerElementoReponer');
$routes->add('solicitar-reposicion-item','Solicitudes::solicitarReposicionItem');
$routes->add('solicitud-reposicion-informacion/(:any)','Solicitudes::informacionSolicitudReposicion/$1');
$routes->add('cambio-estado-solicitud-reposicion/(:any)','Solicitudes::modificarEstadoSolicitudReposicion/$1');
/*
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php'))
{
	require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
